/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.suggestion;

import jakarta.annotation.Nonnull;
import java.util.Optional;

public enum SuggestionState {
    APPLIED(1, "bitbucket.pullrequest.suggestion.apply.alreadyapplied"),
    APPLY_FAILED(2, "bitbucket.pullrequest.suggestion.apply.applyfailed"),
    UNAPPLIED(0, null);

    private final int id;
    private final String applyErrorMessageKey;

    private SuggestionState(int id, String applyErrorMessageKey) {
        this.applyErrorMessageKey = applyErrorMessageKey;
        this.id = id;
    }

    @Nonnull
    public static SuggestionState fromId(int id) {
        for (SuggestionState value : SuggestionState.values()) {
            if (value.getId() != id) continue;
            return value;
        }
        throw new IllegalArgumentException("No SuggestionState is associated with ID [" + id + "]");
    }

    @Nonnull
    public Optional<String> getApplyErrorMessageKey() {
        return Optional.ofNullable(this.applyErrorMessageKey);
    }

    public int getId() {
        return this.id;
    }
}

