/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.user;

import com.atlassian.bitbucket.dmz.user.PermittedPrincipalProjectSearchRequest;
import com.atlassian.bitbucket.dmz.user.PermittedPrincipalRepositorySearchRequest;
import com.atlassian.bitbucket.dmz.user.PrincipalType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ScopeType;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class PermittedPrincipalSearchRequest {
    private final String name;
    private final Set<Permission> permissions;
    private final PrincipalType principalType;
    private final Set<ScopeType> scopes;

    protected PermittedPrincipalSearchRequest(@Nullable String name, @Nullable PrincipalType principalType, @Nonnull Set<Permission> permissions) {
        this.name = name;
        this.principalType = principalType;
        this.permissions = Objects.requireNonNull(permissions, "permissions");
        this.scopes = permissions.stream().map(p -> {
            if (p.isGlobal()) {
                return ScopeType.GLOBAL;
            }
            if (p.isResource(Project.class)) {
                return ScopeType.PROJECT;
            }
            if (p.isResource(Repository.class)) {
                return ScopeType.REPOSITORY;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public abstract <T> T accept(@Nonnull Visitor<T> var1);

    @Nonnull
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        return this.permissions;
    }

    @Nonnull
    public Optional<PrincipalType> getPrincipalType() {
        return Optional.ofNullable(this.principalType);
    }

    @Nonnull
    public Set<ScopeType> getScopes() {
        return this.scopes;
    }

    public static interface Visitor<T> {
        public T visit(@Nonnull PermittedPrincipalProjectSearchRequest var1);

        public T visit(@Nonnull PermittedPrincipalRepositorySearchRequest var1);
    }
}

