/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.ExpiredAuthenticationException;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMirroringUserAuthenticationHandler
implements HttpAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractMirroringUserAuthenticationHandler.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final TransactionTemplate transactionTemplate;

    protected AbstractMirroringUserAuthenticationHandler(AuthenticationContext authenticationContext, I18nService i18nService, TransactionTemplate transactionTemplate) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
        if (!"token".equals(authenticationContext.getMethod())) {
            return null;
        }
        String jwtIssuerId = AbstractMirroringUserAuthenticationHandler.getJwtIssuerId(authenticationContext);
        if (StringUtils.isEmpty((CharSequence)jwtIssuerId)) {
            return null;
        }
        return (AuthenticationResult)this.transactionTemplate.execute(() -> this.getServiceUser(jwtIssuerId, authenticationContext).filter(ApplicationUser::isActive).map(user -> new AuthenticationResult.Builder((ApplicationUser)user).build()).orElse(null));
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
        String jwtIssuerId;
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            return;
        }
        if (this.isMirroringUser(currentUser) && (jwtIssuerId = AbstractMirroringUserAuthenticationHandler.getJwtIssuerId(context)) != null) {
            log.debug("Re-authenticating user {} because the request is JWT signed", (Object)currentUser.getName());
            throw new ExpiredAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.jwt.session.expired", new Object[0]));
        }
    }

    @Nonnull
    protected abstract Optional<ServiceUser> getServiceUser(@Nonnull String var1, @Nonnull HttpAuthenticationContext var2);

    protected abstract boolean isMirroringUser(@Nonnull ApplicationUser var1);

    private static String getJwtIssuerId(HttpAuthenticationContext context) {
        return (String)context.getRequest().getAttribute("Plugin-Key");
    }
}

