/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.hash;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashAuthorizer;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class MirrorRepositoryHashAuthorizer
implements RepositoryHashAuthorizer {
    private final I18nService i18nService;
    private final PermissionService permissionService;

    @Autowired
    public MirrorRepositoryHashAuthorizer(I18nService i18nService, PermissionService permissionService) {
        this.i18nService = i18nService;
        this.permissionService = permissionService;
    }

    @Override
    public void authorize() {
        if (!this.permissionService.hasGlobalPermission(Permission.ADMIN)) {
            throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.operation.not.permitted", new Object[0]));
        }
    }
}

