/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.hash;

import com.atlassian.bitbucket.internal.mirroring.hash.RepositoryHashIdMapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorProjectService;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepositoryService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
class MirrorRepositoryHashIdIdMapper
implements RepositoryHashIdMapper {
    @VisibleForTesting
    static final int BATCH_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(MirrorRepositoryHashIdIdMapper.class);
    private final MirrorProjectService mirrorProjectService;
    private final MirrorRepositoryService mirrorRepositoryService;
    private PageRequest nextProjectPage;
    private Map<Integer, Integer> projectMapping;
    private Map<Integer, Integer> repositoryMapping;

    MirrorRepositoryHashIdIdMapper(MirrorProjectService mirrorProjectService, MirrorRepositoryService mirrorRepositoryService) {
        this.mirrorProjectService = mirrorProjectService;
        this.mirrorRepositoryService = mirrorRepositoryService;
        this.nextProjectPage = PageUtils.newRequest((int)0, (int)100);
        this.loadNextProjectBatch();
    }

    @Override
    public int mapProjectId(int localProjectId) {
        Integer externalProjectId;
        if (this.projectMapping.isEmpty() && this.nextProjectPage != null) {
            this.loadNextProjectBatch();
        }
        if ((externalProjectId = this.projectMapping.remove(localProjectId)) == null) {
            log.debug("Local project with ID [{}] not found in batch, attempting to load directly", (Object)localProjectId);
            externalProjectId = Integer.parseInt(this.mirrorProjectService.getByLocalId(localProjectId).getExternalId());
        }
        this.repositoryMapping = this.mirrorProjectService.mapRepositoryIdsForProject(localProjectId).entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, e -> Integer.parseInt((String)e.getKey())));
        return externalProjectId;
    }

    @Override
    public int mapRepositoryId(int repositoryId) {
        Integer externalRepositoryId = this.repositoryMapping.remove(repositoryId);
        if (externalRepositoryId == null) {
            log.debug("Local repository with ID [{}] not found in batch, attempting to load directly", (Object)repositoryId);
            externalRepositoryId = Integer.parseInt(Objects.requireNonNull(this.mirrorRepositoryService.mapLocalToExternalRepositoryId(repositoryId)));
        }
        return externalRepositoryId;
    }

    private void loadNextProjectBatch() {
        Page<AoProjectMapping> projectMappingPage = this.mirrorProjectService.findAllProjectMappings(this.nextProjectPage);
        this.nextProjectPage = projectMappingPage.getNextPageRequest();
        this.projectMapping = projectMappingPage.stream().collect(Collectors.toMap(AoProjectMapping::getLocalId, m -> Integer.valueOf(m.getExternalId())));
    }
}

