/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.jwt;

import com.atlassian.bitbucket.internal.mirroring.jwt.JwtTokenGenerationException;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.SigningAlgorithm;
import com.atlassian.jwt.core.writer.JwtClaimsBuilder;
import com.atlassian.jwt.httpclient.CanonicalHttpUriRequest;
import com.atlassian.jwt.writer.JwtJsonBuilder;
import com.atlassian.jwt.writer.JwtJsonBuilderFactory;
import com.atlassian.jwt.writer.JwtWriterFactory;
import jakarta.annotation.Nonnull;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class JwtTokenHelper {
    private final JwtJsonBuilderFactory jwtJsonBuilderFactory;
    private final JwtWriterFactory jwtWriterFactory;

    JwtTokenHelper(JwtJsonBuilderFactory jwtJsonBuilderFactory, JwtWriterFactory jwtWriterFactory) {
        this.jwtJsonBuilderFactory = jwtJsonBuilderFactory;
        this.jwtWriterFactory = jwtWriterFactory;
    }

    @Nonnull
    public String generateToken(@Nonnull CanonicalHttpUriRequest request, long expiry, @Nonnull String issuerId, String subject, @Nonnull String sharedSecret) throws JwtTokenGenerationException {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(issuerId, "issuerId");
        Objects.requireNonNull(sharedSecret, "sharedSecret");
        long issuedAt = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        long expiresAt = issuedAt + expiry;
        JwtJsonBuilder jwtBuilder = this.jwtJsonBuilderFactory.jsonBuilder().issuedAt(issuedAt).expirationTime(expiresAt).issuer(issuerId);
        if (subject != null) {
            jwtBuilder.subject(subject);
        }
        try {
            JwtClaimsBuilder.appendHttpRequestClaims((JwtJsonBuilder)jwtBuilder, (CanonicalHttpRequest)request);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new JwtTokenGenerationException("Failed to generate JWT token.", e);
        }
        String json = jwtBuilder.build();
        return this.jwtWriterFactory.macSigningWriter(SigningAlgorithm.HS256, sharedSecret).jsonToJwt(json);
    }
}

