/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.google.common.math.LongMath;
import java.util.concurrent.ThreadLocalRandom;

public class BackoffUtils {
    private BackoffUtils() {
    }

    public static long exponentialDelay(long initialDelay, int attempt) {
        initialDelay = Math.max(1L, initialDelay);
        attempt = Math.max(1, attempt);
        long min = initialDelay * ((LongMath.checkedPow((long)2L, (int)attempt) - 1L) / 2L);
        long max = initialDelay * ((LongMath.checkedPow((long)2L, (int)(attempt + 1)) - 1L) / 2L);
        min = Math.max(1L, min);
        max = Math.max(min + 1L, max);
        return ThreadLocalRandom.current().nextLong(Math.max(1L, min), Math.max(min + 1L, max));
    }
}

