/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleMirroredRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettingService;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepository;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryService;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryStatus;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryCloneLinksRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.IncompatibleApplicationModeException;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.NamedLink;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultMirroredRepositoryService
implements MirroredRepositoryService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirroredRepositoryService.class);
    private final MirroringConfig config;
    private final I18nService i18nService;
    private final InternalUpstreamService upstreamService;
    private final MirrorAuthenticationContext mirrorAuthenticationContext;
    private final PermissionValidationService permissionValidationService;
    private final ProjectMappingDao projectMappingDao;
    private final RepositoryMappingDao repositoryMappingDao;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final UpstreamSettingsService upstreamSettingsService;
    private final UpstreamSshSettingService upstreamSshSettingsService;

    public DefaultMirroredRepositoryService(MirroringConfig config, I18nService i18nService, @Qualifier(value="defaultMirrorAuthenticationContext") MirrorAuthenticationContext mirrorAuthenticationContext, PermissionValidationService permissionValidationService, ProjectMappingDao projectMappingDao, RepositoryMappingDao repositoryMappingDao, RepositoryService repositoryService, SecurityService securityService, InternalUpstreamService upstreamService, UpstreamSettingsService upstreamSettingsService, UpstreamSshSettingService upstreamSshSettingsService) {
        this.config = config;
        this.i18nService = i18nService;
        this.mirrorAuthenticationContext = mirrorAuthenticationContext;
        this.permissionValidationService = permissionValidationService;
        this.projectMappingDao = projectMappingDao;
        this.repositoryMappingDao = repositoryMappingDao;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.upstreamService = upstreamService;
        this.upstreamSettingsService = upstreamSettingsService;
        this.upstreamSshSettingsService = upstreamSshSettingsService;
    }

    @Override
    @Nonnull
    public MirroredRepository getRepository(@Nonnull String externalId) {
        if (!this.upstreamService.isMirror()) {
            throw new IncompatibleApplicationModeException(this.i18nService.createKeyedMessage("bitbucket.mirroring.not.a.mirror", new Object[0]));
        }
        String upstreamId = this.upstreamService.getUpstreamOrFail().getId();
        Repository repository = null;
        AoRepositoryMapping repoMapping = this.repositoryMappingDao.getByUpstreamId(upstreamId, externalId);
        if (repoMapping != null) {
            repository = this.repositoryService.getById(repoMapping.getLocalId().intValue());
        }
        if (repository == null) {
            throw new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.mirrored.repository.mirror", new Object[]{externalId}), null);
        }
        Set<NamedLink> cloneUrls = this.getCloneUrls(repository);
        return new SimpleMirroredRepository.Builder().cloneUrls(cloneUrls).lastUpdated(repoMapping.getLastSyncDate()).mirrorName(this.config.getDisplayName()).pushUrls(this.getPushUrls(cloneUrls, upstreamId)).repositoryId(externalId).status(this.getStatusFor(repository, repoMapping)).build();
    }

    @Override
    @Nonnull
    public MirroredRepositoryStatus getStatus(@Nonnull Repository repository) {
        if (!this.upstreamService.isMirror()) {
            throw new IncompatibleApplicationModeException(this.i18nService.createKeyedMessage("bitbucket.mirroring.not.a.mirror", new Object[0]));
        }
        this.permissionValidationService.validateRepositoryAccessible(repository);
        return this.getStatusFor(repository, this.repositoryMappingDao.getByLocalId(repository.getId()));
    }

    private Set<NamedLink> getCloneUrls(@Nonnull Repository repository) {
        InternalUpstreamServer upstream = this.upstreamService.get();
        if (upstream == null) {
            return Collections.emptySet();
        }
        RepositoryCloneLinksRequest request = new RepositoryCloneLinksRequest.Builder().repository(repository).user((ApplicationUser)this.mirrorAuthenticationContext.getImpersonatedUser().orElse(null)).build();
        return this.repositoryService.getCloneLinks(request);
    }

    private Set<NamedLink> getPushUrls(Set<NamedLink> cloneUrls, String upstreamId) {
        ImmutableSet.Builder filterBuilder = ImmutableSet.builder();
        if (this.config.isHttpWriteEnabled()) {
            filterBuilder.add((Object)"http");
        }
        if (this.config.isSshProxyEnabled() && this.canProxySshPush(upstreamId)) {
            filterBuilder.add((Object)"ssh");
        }
        ImmutableSet filter = filterBuilder.build();
        return (Set)cloneUrls.stream().filter(url -> filter.contains((Object)url.getName())).collect(MoreCollectors.toImmutableSet());
    }

    private boolean canProxySshPush(String upstreamId) {
        InternalUpstreamServer upstreamServer = this.upstreamService.getById(upstreamId).orElse(null);
        if (upstreamServer == null) {
            return false;
        }
        try {
            return this.upstreamSshSettingsService.getSshSettings().isEnabled();
        }
        catch (RuntimeException e) {
            log.warn("Failed to retrieve the SSH settings of upstream {}. Assuming SSH push proxying unsupported or disabled", MirrorDescriptionUtils.describe(upstreamServer), (Object)e);
            return false;
        }
    }

    private MirroredRepositoryStatus getStatusFor(@Nonnull Repository repository, @Nullable AoRepositoryMapping repoMapping) {
        if (repoMapping == null) {
            log.warn("{}: No repository mapping found for local repository", (Object)repository);
            return MirroredRepositoryStatus.NOT_MIRRORED;
        }
        Project project = repository.getProject();
        AoProjectMapping projectMapping = this.projectMappingDao.getByLocalId(project.getId());
        if (projectMapping == null) {
            log.warn("{}: No project mapping found for local project", (Object)project);
            return MirroredRepositoryStatus.NOT_MIRRORED;
        }
        if (!this.getUpstreamSettings(repoMapping.getUpstreamId()).map(s -> s.isMirrored(projectMapping.getExternalId())).orElse(false).booleanValue()) {
            return MirroredRepositoryStatus.NOT_MIRRORED;
        }
        if (repoMapping.getInitialSyncDate() == null) {
            if (repoMapping.getFailedSyncCount() >= this.config.getMaxSyncAttempts()) {
                return MirroredRepositoryStatus.ERROR_INITIALIZING;
            }
            return MirroredRepositoryStatus.INITIALIZING;
        }
        if (repoMapping.getFailedSyncCount() >= this.config.getMaxSyncAttempts()) {
            return MirroredRepositoryStatus.ERROR_AVAILABLE;
        }
        return MirroredRepositoryStatus.AVAILABLE;
    }

    private Optional<UpstreamSettings> getUpstreamSettings(String upstreamId) {
        return (Optional)this.securityService.withPermission(Permission.ADMIN, "Checking upstream settings").call(() -> this.upstreamSettingsService.getSettings(upstreamId));
    }
}

