/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorConstants;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="mirroringConfig")
public class DefaultMirroringConfig
implements MirroringConfig {
    private static final Logger log = LoggerFactory.getLogger(DefaultMirroringConfig.class);
    private final ClusterService clusterService;
    private final ApplicationPropertiesService propertiesService;

    @Autowired
    public DefaultMirroringConfig(ApplicationPropertiesService propertiesService, ClusterService clusterService) {
        this.propertiesService = propertiesService;
        this.clusterService = clusterService;
    }

    @Override
    public Duration getAttributeUpdateInterval() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.attribute.update.interval", 5L));
    }

    @Override
    @Nonnull
    public Duration getBulkMetadataSyncOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.bulk.metadata.sync.timeout", MirrorConstants.DEFAULT_OPERATION_BULK_METADATA_SYNC_TIMEOUT_SECONDS));
    }

    @Override
    public Duration getLockHarvestInterval() {
        return Duration.ofSeconds(this.propertiesService.getPluginProperty("plugin.mirroring.lock.harvest.interval", MirrorConstants.DEFAULT_LOCK_HARVEST_INTERVAL_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getCapabilitiesRefreshInterval() {
        return Duration.ofMinutes(this.getPositiveValue("plugin.mirroring.capabilities.refresh.interval", 10L));
    }

    @Override
    @Nonnull
    public Duration getDelayedSyncRepositoriesQueryOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.delayed.sync.repositories.query", 10));
    }

    @Override
    @Nonnull
    public String getDisplayName() {
        String displayName = this.propertiesService.getDisplayName();
        Preconditions.checkState((displayName != null ? 1 : 0) != 0, (Object)"displayName");
        return displayName;
    }

    @Override
    public int getFallbackAuthCacheMaxEntries() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.upstream.auth.cache.fallback.max", -1);
    }

    @Override
    public long getFallbackAuthCacheTtl() {
        long recentAuthTtl;
        long configuredTtl = Math.max(0L, this.propertiesService.getPluginProperty("plugin.mirroring.upstream.auth.cache.fallback.ttl", 1800L));
        if (configuredTtl > 0L && configuredTtl < (recentAuthTtl = this.getRecentAuthCacheTtl())) {
            log.debug("Adjusting fallback auth cache TTL of {} seconds upwards to that of the recent auth cache ({} seconds) because as a smaller value eliminates its effectiveness", (Object)configuredTtl, (Object)recentAuthTtl);
            configuredTtl = recentAuthTtl;
        }
        return configuredTtl;
    }

    @Override
    public int getFarmOperationCallbackThreadCount() {
        return this.getPositiveValue("plugin.mirroring.farm.operation.callback.threads", 2);
    }

    @Override
    @Nonnull
    public Duration getLocalCommandIdleTimeout() {
        return Duration.ofSeconds(this.propertiesService.getPluginProperty("plugin.mirroring.local.command.timeout.idle", 180L));
    }

    @Override
    public int getFarmOperationThreadCount() {
        return this.getPositiveValue("plugin.mirroring.farm.operation.threads", 5);
    }

    @Override
    public int getFarmVetFirstRunRetryAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.vet.first.run.retry.attempts", 10);
    }

    @Override
    public int getFarmVetThreadCount() {
        return this.getPositiveValue("plugin.mirroring.farm.vet.threads", 5);
    }

    @Override
    public int getInitialSyncThreadCount() {
        return this.getPositiveValue("plugin.mirroring.initial.sync.threads", 5);
    }

    @Override
    @Nonnull
    public Duration getJwtLifetime() {
        return Duration.ofSeconds(Math.max(0L, this.propertiesService.getPluginProperty("plugin.mirroring.jwt.lifetime", 180L)));
    }

    @Override
    public boolean getLfsDownloadFromUpstream() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.lfs.download.upstream", false);
    }

    @Override
    public int getMaxChunkSize() {
        return this.getPositiveValue("plugin.mirroring.farm.max.chunk.size", 5000);
    }

    @Override
    public int getMaxInflightOperations() {
        return this.getPositiveValue("plugin.mirroring.farm.operation.max.inflight", 1000);
    }

    @Override
    public int getMaxLockAcquisitionAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.max.lock.acquisition.attempts", 1800);
    }

    @Override
    public int getMaxRefChangeQueueDumpSize() {
        return this.getPositiveValue("plugin.mirroring.farm.max.ref.change.queue.dump.size", 128);
    }

    @Override
    public int getMaxOperationAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.operation.max.attempts", 5);
    }

    @Override
    public int getMaxQueueAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.queue.request.max.submissions", 5);
    }

    @Override
    public int getMaxSyncAttempts() {
        return this.getPositiveValue("plugin.mirroring.synchronization.max.attempts", 3);
    }

    @Override
    public int getMaxUpstreamEventPublishAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.upstream.event.retry.delay", 5);
    }

    @Override
    public MirrorType getMirrorType() {
        return this.clusterService.getInformation().isNetworkingEnabled() ? MirrorType.FARM : MirrorType.SINGLE;
    }

    @Override
    @Nonnull
    public Duration getOperationCallbackTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.operation.callback.timeout", 300L));
    }

    @Override
    @Nonnull
    public Duration getOperationInitialRetryDelay() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.initial.retry.delay", 10L));
    }

    @Override
    @Nonnull
    public Duration getProjectMetadataOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.project.metadata.timeout", MirrorConstants.DEFAULT_OPERATION_PROJECT_METADATA_TIMEOUT_SECONDS));
    }

    @Override
    public int getProjectMetadataQueuePollerThreads() {
        return this.getPositiveValue("plugin.mirroring.farm.project.metadata.queue.threads", 1);
    }

    @Override
    public Duration getQueueInitialRetryDelay() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.queue.initial.retry.delay", 5L));
    }

    @Override
    public int getRecentAuthCacheMaxEntries() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.upstream.auth.cache.max", -1);
    }

    @Override
    public long getRecentAuthCacheTtl() {
        return Math.max(0L, this.propertiesService.getPluginProperty("plugin.mirroring.upstream.auth.cache.ttl", 300L));
    }

    @Override
    @Nonnull
    public Duration getRefChangeChunkOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.refchange.chunk.timeout", MirrorConstants.DEFAULT_OPERATION_REFCHANGE_CHUNK_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getRemoteCommandIdleTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.remote.command.timeout.idle", MirrorConstants.DEFAULT_REMOTE_COMMAND_IDLE_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getRepositoryDefaultBranchOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.repository.default.branch.timeout", MirrorConstants.DEFAULT_OPERATION_REPOSITORY_DEFAULT_BRANCH_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getRepositoryLockQueryTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.repository.lock.query.timeout", MirrorConstants.DEFAULT_OPERATION_REPOSITORY_LOCK_QUERY_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getRepositoryDeleteOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.repository.delete.timeout", MirrorConstants.DEFAULT_OPERATION_REPOSITORY_DELETE_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getRepositoryDiagnosticsSyncTolerance() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.repository.diagnostics.sync.tolerance", MirrorConstants.DEFAULT_REPOSITORY_DIAGNOSTICS_SYNC_TOLERANCE));
    }

    @Override
    @Nonnull
    public Duration getRepositoryLockOwnerQueryOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.repository.lock.owner.query", MirrorConstants.DEFAULT_OPERATION_REPOSITORY_LOCK_OWNER_TIMEOUT_SECONDS));
    }

    @Override
    public int getRepositoryMetadataQueuePollerThreads() {
        return this.getPositiveValue("plugin.mirroring.farm.repository.metadata.queue.threads", 1);
    }

    @Override
    public int getRepositoryRefChangesQueuePollerThreads() {
        return this.getPositiveValue("plugin.mirroring.farm.repository.refchanges.queue.threads", 5);
    }

    @Override
    @Nonnull
    public Duration getRollingUpgradeOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.rolling.upgrade.timeout", MirrorConstants.DEFAULT_OPERATION_ROLLING_UPGRADE_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public String getServerId() {
        return Objects.requireNonNull(this.propertiesService.getServerId(), "serverId");
    }

    @Override
    @Nonnull
    public Optional<String> getServerUpstreamUrl() {
        return Optional.ofNullable(this.propertiesService.getPluginProperty("plugin.mirroring.upstream.url", null));
    }

    @Override
    @Nonnull
    public Duration getSingleRepositoryMetadataOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.single.repository.metadata.timeout", MirrorConstants.DEFAULT_OPERATION_SINGLE_REPOSITORY_METADATA_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getSshProxyUpstreamAuthTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.ssh.proxy.upstream.timeout.auth", 90L));
    }

    @Override
    @Nonnull
    public Duration getSshProxyUpstreamChannelTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.ssh.proxy.upstream.timeout.channel", 30L));
    }

    @Override
    @Nonnull
    public Duration getSshProxyUpstreamConnectionTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.ssh.proxy.upstream.timeout.connect", 20L));
    }

    @Override
    @Nonnull
    public Duration getSshProxyUpstreamExecutionTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.ssh.proxy.upstream.timeout.execution", 86400L));
    }

    @Override
    @Nonnull
    public Duration getSshProxyUpstreamIdleTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.ssh.proxy.upstream.timeout.idle", 1800L));
    }

    @Override
    @Nonnull
    public Duration getStateRefreshInterval() {
        return Duration.ofMinutes(this.getPositiveValue("plugin.mirroring.state.refresh.interval", 1L));
    }

    @Override
    @Nonnull
    public Duration getSyncExecTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.synchronization.fetch.timeout.execution", MirrorConstants.DEFAULT_SYNC_TIMEOUT_EXEC_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getSyncInitialDelay() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.synchronization.delay.initial", 15L));
    }

    @Override
    @Nonnull
    public Duration getSyncInterval() {
        return Duration.ofMinutes(this.getPositiveValue("plugin.mirroring.synchronization.interval", 3L));
    }

    @Override
    @Nonnull
    public Duration getSyncLsRemoteTimeout() {
        return Duration.ofMinutes(this.getPositiveValue("plugin.mirroring.synchronization.ls-remote.timeout", 15L));
    }

    @Override
    @Nonnull
    public Duration getTopicInitialRetryDelay() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.topic.initial.retry.delay", 2));
    }

    @Override
    public int getTopicMaxAttempts() {
        return this.getPositiveValue("plugin.mirroring.farm.topic.max.attempts", 2);
    }

    @Override
    @Nonnull
    public Duration getUpdateRefsOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.update.refs.timeout", MirrorConstants.DEFAULT_OPERATION_UPDATE_REFS_TIMEOUT_SECONDS));
    }

    @Override
    public Duration getUpstreamEventPublishInitialRetryDelay() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.upstream.event.initial.retry.delay", 10));
    }

    @Override
    public int getUpstreamEventRefChangeMaxSize() {
        return this.getPositiveValue("plugin.mirroring.upstream.event.ref.change.max.count", 25);
    }

    @Override
    @Nonnull
    public Duration getUpstreamMaxClockDelta() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.upstream.max.clock.delta", MirrorConstants.DEFAULT_UPSTREAM_MAX_CLOCK_DELTA_SECONDS));
    }

    @Override
    public int getUpstreamRepositoryRequestPageSize() {
        return this.getPositiveValue("plugin.mirroring.synchronization.repository.page.size.max", 100);
    }

    @Override
    @Nonnull
    public Duration getUpstreamSettingsOperationTimeout() {
        return Duration.ofSeconds(this.getPositiveValue("plugin.mirroring.farm.operation.upstream.settings.timeout", MirrorConstants.DEFAULT_OPERATION_UPSTREAM_SETTINGS_TIMEOUT_SECONDS));
    }

    @Override
    @Nonnull
    public Duration getUpstreamSettingsSyncInterval() {
        return Duration.ofMinutes(this.getPositiveValue("plugin.mirroring.upstream.settings.sync.interval", 15));
    }

    @Override
    public boolean isAuthCachingEnabled() {
        return this.getFallbackAuthCacheTtl() > 0L && this.getFallbackAuthCacheMaxEntries() != 0 || this.getRecentAuthCacheTtl() > 0L && this.getRecentAuthCacheMaxEntries() != 0;
    }

    @Override
    public boolean isAuthCachingInvalidationEnabled() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.upstream.auth.cache.invalidation.enabled", true);
    }

    @Override
    public boolean isHttpWriteEnabled() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.http.write.enabled", true);
    }

    @Override
    public boolean isRepositorySyncDiagnosticsEnabled() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.repository.diagnostics.sync.enabled", false);
    }

    @Override
    public boolean isSshProxyConfigParsed() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.ssh.proxy.parseconfig", false);
    }

    @Override
    public boolean isSshProxyEnabled() {
        return this.propertiesService.getPluginProperty("plugin.mirroring.ssh.proxy.enabled", true);
    }

    private int getPositiveValue(String propName, int defaultValue) {
        return Ints.saturatedCast((long)this.getPositiveValue(propName, (long)defaultValue));
    }

    private long getPositiveValue(String propName, long defaultValue) {
        long value;
        try {
            value = this.propertiesService.getPluginProperty(propName, defaultValue);
            if (value <= 0L) {
                log.warn("Property {} must be positive. But was {} Defaulting to {}", new Object[]{propName, value, defaultValue});
                value = defaultValue;
            }
        }
        catch (IllegalArgumentException e) {
            log.warn("Property {} has an invalid value. Defaulting to {}", new Object[]{propName, defaultValue, e});
            value = defaultValue;
        }
        return value;
    }
}

