/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.mirroring.mirror.AnalyticsService;
import com.atlassian.bitbucket.mirroring.mirror.AnalyticsSettings;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpstreamAnalyticsService
implements AnalyticsService {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamAnalyticsService.class);
    private final MirroringConfig mirroringConfig;
    private final UpstreamService upstreamService;
    private final I18nService i18nService;
    private final InternalUpstreamClientFactory upstreamClientFactory;

    public DefaultUpstreamAnalyticsService(@Nonnull InternalUpstreamClientFactory upstreamClientFactory, @Nonnull MirroringConfig mirroringConfig, @Nonnull UpstreamService upstreamService, @Nonnull I18nService i18nService) {
        this.upstreamClientFactory = upstreamClientFactory;
        this.mirroringConfig = mirroringConfig;
        this.upstreamService = upstreamService;
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    public AnalyticsSettings getAnalyticsSettings() {
        UpstreamServer upstream = this.upstreamService.get();
        if (upstream == null) {
            log.debug("No upstream server found. Analytics lookup failed");
            throw new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[0]));
        }
        AnalyticsSettings settings = this.upstreamClientFactory.create(upstream).getAnalyticsSettings();
        settings.getServerTime().ifPresent(time -> {
            long delta = Math.abs(Instant.now().getEpochSecond() - time);
            if (delta > this.mirroringConfig.getUpstreamMaxClockDelta().getSeconds()) {
                log.warn("Upstream and mirror clocks are out of sync by {}s, check the system clocks on the upstream and mirror nodes. This can sometimes cause JWT authentication to fail", (Object)delta);
            }
        });
        return settings;
    }
}

