/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.SimpleMirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.SimpleMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.DefaultSyncProgress;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InvalidUpstreamServerUrlException;
import com.atlassian.bitbucket.internal.mirroring.mirror.JohnsonHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.LogUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.SyncProgressUpdatedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamServerJwtIssuer;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoProjectMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.CreateUpstreamServerRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.ProjectMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.MirrorJwtTokenHelper;
import com.atlassian.bitbucket.mirroring.MirroringCapabilities;
import com.atlassian.bitbucket.mirroring.MirroringFeature;
import com.atlassian.bitbucket.mirroring.mirror.AbstractRetryableUpstreamRepositoryEvent;
import com.atlassian.bitbucket.mirroring.mirror.FullSynchronizationEvent;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.MirrorInstalledUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorPendingInstallUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorRemovedUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.MirrorStateUpstreamUnknownEvent;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.ProjectSynchronizationFailedEvent;
import com.atlassian.bitbucket.mirroring.mirror.ProjectSynchronizedEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.server.IncompatibleApplicationModeException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jwt.JwtIssuer;
import com.atlassian.jwt.JwtIssuerRegistry;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpstreamService
implements InternalUpstreamService,
JwtIssuerRegistry,
LifecycleAware {
    private static final String MIN_UPSTREAM_VERSION = "9.0";
    private static final String MIRROR_NAME_PREFIX = "Mirror - ";
    private static final long REFRESH_DELAY_MS = TimeUnit.SECONDS.toMillis(10L);
    private static final Void VOID_RESULT = null;
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamService.class);
    private final AuthenticationContext authenticationContext;
    private final Map<String, MirroringCapabilities> capabilitiesCache;
    private final MirroringConfig config;
    private final EventPublisher eventPublisher;
    private final ScheduledExecutorService executorService;
    private final I18nService i18nService;
    private final JohnsonHelper johnsonHelper;
    private final MirrorJwtTokenHelper jwtTokenHelper;
    private final ProjectMappingDao projectMappingDao;
    private final ApplicationPropertiesService propertiesService;
    private final RepositoryMappingDao repositoryMappingDao;
    private final UpstreamUserHelper securityHelper;
    private final TransactionTemplate transactionTemplate;
    private final InternalUpstreamClientFactory upstreamClientFactory;
    private final UpstreamServerDao upstreamServerDao;
    private boolean johnsoned;

    public DefaultUpstreamService(AuthenticationContext authenticationContext, MirroringConfig config, EventPublisher eventPublisher, ScheduledExecutorService executorService, I18nService i18nService, JohnsonHelper johnsonHelper, MirrorJwtTokenHelper jwtTokenHelper, ProjectMappingDao projectMappingDao, ApplicationPropertiesService propertiesService, RepositoryMappingDao repositoryMappingDao, UpstreamUserHelper securityHelper, TransactionTemplate transactionTemplate, InternalUpstreamClientFactory upstreamClientFactory, UpstreamServerDao upstreamServerDao) {
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.johnsonHelper = johnsonHelper;
        this.jwtTokenHelper = jwtTokenHelper;
        this.projectMappingDao = projectMappingDao;
        this.propertiesService = propertiesService;
        this.repositoryMappingDao = repositoryMappingDao;
        this.securityHelper = securityHelper;
        this.transactionTemplate = transactionTemplate;
        this.upstreamClientFactory = upstreamClientFactory;
        this.upstreamServerDao = upstreamServerDao;
        this.capabilitiesCache = new ConcurrentHashMap<String, MirroringCapabilities>();
    }

    public JwtIssuer getIssuer(@Nonnull String issuer) {
        Objects.requireNonNull(issuer, "issuer");
        InternalUpstreamServer upstream = (InternalUpstreamServer)this.inTransaction(() -> this.upstreamServerDao.getByIssuerId(issuer));
        return upstream == null ? null : new UpstreamServerJwtIssuer(upstream);
    }

    @Override
    public InternalUpstreamServer get() {
        if (!this.isMirror()) {
            return null;
        }
        return (InternalUpstreamServer)this.inTransaction(this.upstreamServerDao::getUpstream);
    }

    @Override
    @Nonnull
    public InternalUpstreamServer getOrCreateUpstream() {
        AoUpstreamServer upstream = this.getOrCreateUpstreamServer();
        this.validateUpstream(upstream);
        return upstream;
    }

    @Override
    @Nonnull
    public AoUpstreamServer getUpstreamOrFail(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        if (!this.isMirror()) {
            throw this.notAMirrorException();
        }
        AoUpstreamServer upstream = (AoUpstreamServer)this.inTransaction(() -> this.upstreamServerDao.getById(upstreamId));
        if (upstream == null) {
            throw this.throwNoSuchUpstream(upstreamId);
        }
        return upstream;
    }

    @Override
    @Nonnull
    public InternalUpstreamServer getUpstreamOrFail() {
        return this.tryGetUpstream();
    }

    @Override
    @Nonnull
    public Optional<InternalUpstreamServer> getById(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        InternalUpstreamServer internalUpstreamServer = this.get();
        if (internalUpstreamServer == null || !internalUpstreamServer.getId().equals(upstreamId)) {
            return Optional.empty();
        }
        return Optional.of(internalUpstreamServer);
    }

    @Override
    @Nonnull
    public InternalUpstreamServer create(@Nonnull String url) throws IllegalStateException {
        Objects.requireNonNull(url, "url");
        if (!this.isValidUrl(url)) {
            throw new IllegalArgumentException(String.format("Upstream '%s' is not a valid URL.", url));
        }
        return this.createSingleUpstream(url);
    }

    @Override
    @Nonnull
    public Optional<String> getUpstreamHandshakeId() {
        InternalUpstreamClient upstreamClient = this.upstreamClientFactory.create(this.tryGetUpstream());
        return Optional.ofNullable(upstreamClient.getUpstreamHandshakeId());
    }

    @Override
    @Nonnull
    public DefaultSyncProgress getSynchronizationProgress(@Nonnull UpstreamServer upstream) {
        return (DefaultSyncProgress)this.inTransaction(() -> {
            String upstreamId = upstream.getId();
            return this.maybeClearProgress(upstreamId);
        });
    }

    @Override
    public boolean isMirror() {
        return this.propertiesService.getMode() == ApplicationMode.MIRROR;
    }

    @EventListener
    public void onFullSynchronizationEvent(FullSynchronizationEvent event) {
        this.inTransactionVoid(() -> {
            String upstreamId = event.getUpstream().getId();
            this.maybeClearProgress(upstreamId);
            this.upstreamServerDao.setLastFullSyncDate(upstreamId, event.getStartDate());
            this.upstreamServerDao.setInitialSyncDateForProjects(upstreamId, event.getSyncedExternalProjectIds(), event.getDate());
        });
        this.publishSyncProgressUpdated(event.getUpstream());
    }

    @EventListener
    public void onProjectSynchronizationFailed(ProjectSynchronizationFailedEvent event) {
        this.inTransactionVoid(() -> this.maybeClearProgress(event.getUpstreamServerId()));
    }

    @EventListener
    public void onProjectSynchronized(ProjectSynchronizedEvent event) {
        String upstreamId = event.getUpstreamServerId();
        this.inTransactionVoid(() -> {
            this.maybeClearProgress(upstreamId);
            this.upstreamServerDao.setInitialSyncDateForProjects(upstreamId, (Set<String>)ImmutableSet.of((Object)event.getExternalProjectId()), event.getDate());
        });
        this.publishSyncProgressUpdated(this.getUpstreamOrFail(upstreamId));
    }

    @EventListener
    public void onRepositorySynchronizationFailed(RepositorySynchronizationFailedEvent event) {
        Repository repository = event.getRepository();
        String upstreamServer = event.getUpstreamServer();
        this.inTransactionVoid(() -> {
            int failedSyncCount = this.repositoryMappingDao.incrementFailedSyncCount(repository.getId());
            if (failedSyncCount >= this.config.getMaxSyncAttempts()) {
                log.warn("{}: Repository with ID ({}) failed to sync {} times in a row. Further attempts won't be made until the repository is next updated.", new Object[]{repository, event.getExternalRepositoryId(), failedSyncCount});
            }
            this.maybeClearProgress(upstreamServer);
        });
        this.publishSyncProgressUpdated(this.getUpstreamOrFail(upstreamServer));
    }

    @EventListener
    public void onRepositorySynchronizationFailedOnFarm(RepositorySynchronizationFailedOnFarmEvent event) {
        Repository repository = event.getRepository();
        InternalUpstreamClient upstreamClient = this.upstreamClientFactory.create(this.tryGetUpstream());
        try {
            upstreamClient.notifyRepositorySynchronizationFailed(event, event.getExternalRepositoryId());
            log.debug("{}: Notified upstream that repository with ID ({}) failed to synchronize", (Object)repository, (Object)event.getExternalRepositoryId());
        }
        catch (Exception e) {
            this.maybeAttemptRepublishEvent(event, e);
        }
    }

    @EventListener
    public void onRepositorySynchronized(RepositorySynchronizedEvent event) {
        Repository repository = event.getRepository();
        String upstreamServer = event.getUpstreamServer();
        log.debug("{}: Repository with ID ({}) synchronized!", (Object)repository, (Object)event.getExternalRepositoryId());
        this.inTransactionVoid(() -> {
            this.repositoryMappingDao.updateSyncDate(repository.getId(), event.getDate());
            this.maybeClearProgress(upstreamServer);
        });
        this.publishSyncProgressUpdated(this.getUpstreamOrFail(upstreamServer));
    }

    @EventListener
    public void onRepositorySynchronizedOnFarm(RepositorySynchronizedOnFarmEvent event) {
        Repository repository = event.getRepository();
        RepositorySynchronizedOnFarmEvent truncatedEvent = this.maybeTruncateRefs(event);
        InternalUpstreamClient upstreamClient = this.upstreamClientFactory.create(this.tryGetUpstream());
        try {
            upstreamClient.notifyRepositorySynchronized(truncatedEvent, event.getExternalRepositoryId());
            log.debug("{}: Notified upstream that repository with ID ({}) has been synchronized", (Object)repository, (Object)event.getExternalRepositoryId());
        }
        catch (Exception e) {
            this.maybeAttemptRepublishEvent(truncatedEvent, e);
        }
    }

    @Override
    @Nonnull
    public UpstreamServer onInstalled(@Nonnull UpstreamInstallationParameters installedParameters) {
        Objects.requireNonNull(installedParameters, "installedParameters");
        return (UpstreamServer)this.inTransaction(() -> {
            IntegrationState state;
            InternalUpstreamServer upstream = this.getUpstreamOrFail();
            String upstreamId = upstream.getId();
            if (!this.isAuthenticatedAsUpstream(upstreamId) && (state = upstream.getState()) != IntegrationState.INITIALIZING && state != IntegrationState.PENDING) {
                throw this.throwNotPermitted();
            }
            AoUpstreamServer aoUpstream = this.upstreamServerDao.setInstalledParameters(installedParameters);
            if (aoUpstream == null) {
                throw this.throwNoSuchUpstream(upstreamId);
            }
            return this.setIntegrationState(aoUpstream, IntegrationState.INSTALLED);
        });
    }

    public void onStart() {
        InternalUpstreamServer upstreamServer = this.get();
        if (upstreamServer != null) {
            this.validateUpstream(upstreamServer);
        }
    }

    public void onStop() {
    }

    @Override
    public void onUninstalled(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        this.onStateUpdated(upstreamId, IntegrationState.REMOVED);
    }

    @Override
    @Nonnull
    public UpstreamServer refresh(@Nonnull UpstreamServer upstream) {
        log.debug("Refreshing mirroring state with upstream {}", MirrorDescriptionUtils.describe(upstream));
        IntegrationState upstreamState = this.refreshUpstreamState(upstream);
        return this.updateUpstreamServerDetails(upstream.getId(), upstreamState);
    }

    @Override
    public void refreshCapabilities(@Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(upstream, "upstream");
        try {
            MirroringCapabilities capabilities = this.upstreamClientFactory.create(upstream).getCapabilities();
            this.capabilitiesCache.put(upstream.getId(), capabilities);
            log.debug("Finished retrieving upstream capabilities for {}", MirrorDescriptionUtils.describe(upstream));
        }
        catch (Exception e) {
            log.warn("Failed retrieving upstream capabilities for {} ({})", new Object[]{MirrorDescriptionUtils.describe(upstream), e.getMessage(), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e)});
        }
    }

    @Override
    public void register() {
        this.checkIsMirror();
        AoUpstreamServer upstream = this.getOrCreateUpstreamServer();
        this.validateUpstream(upstream);
        if (upstream.getState() == IntegrationState.REMOVED) {
            upstream = this.setIntegrationState(upstream.getId(), IntegrationState.INITIALIZING);
        }
        if (upstream.getState() == IntegrationState.INITIALIZING || upstream.getState() == IntegrationState.PENDING) {
            this.registerUpstream(upstream);
        }
    }

    @Override
    @Nonnull
    public Map<String, Integer> mapToLocalProjects(@Nonnull String upstreamId, @Nonnull Iterable<String> upstreamProjectIds) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        Objects.requireNonNull(upstreamProjectIds, "upstreamProjectIds");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterable<AoProjectMapping> mappings = this.projectMappingDao.getByUpstreamId(upstreamId, upstreamProjectIds);
        for (AoProjectMapping mapping : mappings) {
            builder.put((Object)mapping.getExternalId(), (Object)mapping.getLocalId());
        }
        return builder.build();
    }

    @Override
    @Nonnull
    public Map<String, Integer> mapToLocalRepositories(@Nonnull String upstreamId, @Nonnull Iterable<String> upstreamRepositoryIds) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        Objects.requireNonNull(upstreamRepositoryIds, "upstreamRepositoryIds");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Iterable<AoRepositoryMapping> mappings = this.repositoryMappingDao.getByUpstreamId(upstreamId, upstreamRepositoryIds);
        for (AoRepositoryMapping mapping : mappings) {
            builder.put((Object)mapping.getExternalId(), (Object)mapping.getLocalId());
        }
        return builder.build();
    }

    @Override
    public void upgrade(@Nonnull UpstreamServer upstream) {
        this.upstreamClientFactory.create(upstream).upgradeMirror(new SimpleMirrorUpgradeRequest.Builder(this.config.getServerId()).baseUrl(Objects.requireNonNull(this.propertiesService.getBaseUrl()).toASCIIString()).productVersion(StringUtils.abbreviate((String)this.propertiesService.getBuildVersion(), (int)64)).build());
    }

    @Override
    public void createAndBootstrapUpstreamServer(@Nonnull InternalUpstreamServer internalUpstreamServer) {
        Objects.requireNonNull(internalUpstreamServer, "internalUpstreamServer");
        log.info("Creating UpstreamServer{baseUrl={}}", (Object)internalUpstreamServer.getBaseUrl());
        AoUpstreamServer upstreamServer = (AoUpstreamServer)this.inTransaction(() -> this.createUpstreamInternal(internalUpstreamServer.getBaseUrl()));
        log.debug("Updating upstream {} with state {}", MirrorDescriptionUtils.describe(upstreamServer), (Object)internalUpstreamServer.getState());
        this.upstreamServerDao.transitionState(upstreamServer, internalUpstreamServer.getState());
        if (internalUpstreamServer.getState() == IntegrationState.INSTALLED) {
            try {
                this.overrideUpstreamInstallationParameters(UpstreamInstallationParameters.builder().issuerId(internalUpstreamServer.getIssuerId().orElseThrow(() -> new IllegalArgumentException("issuerId"))).secret(internalUpstreamServer.getSharedSecret().orElseThrow(() -> new IllegalArgumentException("secret"))).build());
            }
            catch (IllegalArgumentException e) {
                KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.registration.error", new Object[]{e.getMessage() + " missing"});
                this.addJohnsonEvent(message);
                throw new ArgumentValidationException(message);
            }
        }
        log.debug("Creating service user for upstream {}", MirrorDescriptionUtils.describe(internalUpstreamServer));
        this.securityHelper.createNewOrActivateExistingUserForUpstream(internalUpstreamServer.getId());
    }

    @Override
    public void refreshContentHash(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        InternalUpstreamServer upstream = this.tryGetUpstream();
        MirroringCapabilities capabilities = this.getCapabilities(upstream);
        if (capabilities == null || !capabilities.getFeatures().contains((Object)MirroringFeature.REPOSITORY_CONTENT_HASH_REFRESH)) {
            return;
        }
        log.debug("Refreshing content hash for repository with ID ({}) on upstream", (Object)externalRepositoryId);
        this.upstreamClientFactory.create(upstream).refreshContentHash(externalRepositoryId);
    }

    @Override
    public void upsertUpstream(@Nonnull InternalUpstreamServer upstream) {
        Objects.requireNonNull(upstream, "upstream");
        InternalUpstreamServer localUpstream = this.get();
        if (localUpstream != null) {
            if (localUpstream.getState() != upstream.getState()) {
                log.debug("Transitioning upstream {} from {} to {}", new Object[]{MirrorDescriptionUtils.describe(localUpstream), localUpstream.getState(), upstream.getState()});
                this.upstreamServerDao.transitionState(localUpstream.getId(), upstream.getState());
            } else {
                log.trace("No state changes required, local upstream server is up to date with shared upstream server");
            }
        } else {
            this.createAndBootstrapUpstreamServer(upstream);
        }
        if (upstream.getState() == IntegrationState.INSTALLED) {
            log.info("Upserting service user for upstream {}", (Object)upstream.getId());
            this.securityHelper.createNewOrActivateExistingUserForUpstream(upstream.getId());
        } else if (upstream.getState() == IntegrationState.REMOVED) {
            log.info("Deactivating service user for upstream {}", (Object)upstream.getId());
            this.securityHelper.deactivateUserForUpstream(upstream.getId());
        }
    }

    @Override
    public InternalUpstreamServer overrideUpstreamInstallationParameters(@Nonnull UpstreamInstallationParameters installationParameters) {
        Objects.requireNonNull(installationParameters, "installationParameters");
        log.debug("Updating {}", (Object)installationParameters);
        AoUpstreamServer upstreamServer = this.upstreamServerDao.setInstalledParameters(installationParameters);
        this.jwtTokenHelper.clearCache();
        return upstreamServer;
    }

    @Override
    public InternalUpstreamServer updateLastFullSyncDate(@Nonnull String upstreamServerId, @Nonnull Date lastFullSyncDate) {
        Objects.requireNonNull(upstreamServerId, "upstreamServerId");
        Objects.requireNonNull(lastFullSyncDate, "fullSynchronizationDate");
        return this.upstreamServerDao.setLastFullSyncDate(upstreamServerId, lastFullSyncDate);
    }

    @Override
    @Nullable
    public MirroringCapabilities getCapabilities(UpstreamServer upstream) {
        if (!this.capabilitiesCache.containsKey(upstream.getId())) {
            this.refreshCapabilities(upstream);
        }
        return this.capabilitiesCache.get(upstream.getId());
    }

    private boolean isValidUrl(String baseUrl) {
        try {
            new URL(baseUrl);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    private DefaultSyncProgress maybeClearProgress(String upstreamId) {
        int syncedRepos = this.repositoryMappingDao.countSyncedInProgress(upstreamId);
        int totalRepos = this.repositoryMappingDao.countAllInProgress(upstreamId);
        boolean discovering = this.upstreamServerDao.isDiscovering(upstreamId);
        log.trace("clearProgress? syncedRepos = {} totalRepos = {} discovering = {}", new Object[]{syncedRepos, totalRepos, discovering});
        if (syncedRepos >= totalRepos && totalRepos != 0 && !discovering) {
            log.trace("Clearing progress! syncedRepos = {} totalRepos = {} discovering = {}", new Object[]{syncedRepos, totalRepos, false});
            this.projectMappingDao.clearAllProgress(upstreamId);
            return new DefaultSyncProgress(false, 0, 0);
        }
        return new DefaultSyncProgress(discovering, syncedRepos, totalRepos);
    }

    private void publishSyncProgressUpdated(UpstreamServer upstream) {
        this.eventPublisher.publish((Object)new SyncProgressUpdatedEvent(this, this.getSynchronizationProgress(upstream)));
    }

    private InternalUpstreamServer updateUpstreamServerDetails(@Nonnull String upstreamId, @Nonnull IntegrationState state) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        Objects.requireNonNull(state, "state");
        return (InternalUpstreamServer)this.inTransaction(() -> this.setIntegrationState(upstreamId, state));
    }

    private AoUpstreamServer setIntegrationState(@Nonnull String upstreamId, @Nonnull IntegrationState state) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        Objects.requireNonNull(state, "state");
        return (AoUpstreamServer)this.inTransaction(() -> {
            AoUpstreamServer upstream = this.upstreamServerDao.getById(upstreamId);
            if (upstream == null) {
                throw this.throwNoSuchUpstream(upstreamId);
            }
            return this.setIntegrationState(upstream, state);
        });
    }

    private AoUpstreamServer setIntegrationState(@Nonnull AoUpstreamServer upstream, @Nonnull IntegrationState state) {
        Objects.requireNonNull(upstream, "upstream");
        Objects.requireNonNull(state, "state");
        String upstreamId = upstream.getId();
        IntegrationState currentState = upstream.getState();
        if (currentState == state) {
            return upstream;
        }
        if (currentState == IntegrationState.REMOVED && state != IntegrationState.INITIALIZING) {
            log.trace("Upstream state is REMOVED. Ignoring request to set the state to {}", (Object)state);
            return upstream;
        }
        if (state == IntegrationState.UNKNOWN && (currentState == IntegrationState.INITIALIZING || currentState == IntegrationState.PENDING)) {
            log.trace("Upstream state is {}. Ignoring request to set the state to UNKNOWN", (Object)currentState);
            return upstream;
        }
        if (EnumSet.of(IntegrationState.INITIALIZING, IntegrationState.PENDING).contains((Object)state)) {
            log.debug("Setting upstream state for {} to {}", (Object)upstreamId, (Object)state);
        } else {
            log.info("Setting upstream state for {} to {}", (Object)upstreamId, (Object)state);
        }
        upstream = this.upstreamServerDao.transitionState(upstream, state);
        switch (state) {
            case INSTALLED: {
                this.securityHelper.createNewOrActivateExistingUserForUpstream(upstreamId);
                this.eventPublisher.publish((Object)new MirrorInstalledUpstreamEvent(this, upstream));
                break;
            }
            case PENDING: {
                this.eventPublisher.publish((Object)new MirrorPendingInstallUpstreamEvent(this, upstream));
                break;
            }
            case REMOVED: {
                this.securityHelper.deactivateUserForUpstream(upstreamId);
                this.eventPublisher.publish((Object)new MirrorRemovedUpstreamEvent(this, upstream));
                break;
            }
            case UNKNOWN: {
                this.eventPublisher.publish((Object)new MirrorStateUpstreamUnknownEvent(this, upstream));
            }
        }
        return upstream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJohnsonEvent(KeyedMessage message) {
        if (this.johnsoned) {
            return;
        }
        DefaultUpstreamService defaultUpstreamService = this;
        synchronized (defaultUpstreamService) {
            if (this.johnsoned) {
                return;
            }
            this.johnsoned = true;
            this.johnsonHelper.addJohnsonEvent("plugin-failed", message.getLocalisedMessage(), "error");
        }
    }

    private void checkIsMirror() {
        if (!this.isMirror()) {
            throw this.notAMirrorException();
        }
    }

    private void validateUpstream(UpstreamServer upstreamServer) {
        if (upstreamServer == null) {
            return;
        }
        List<MirroringFeature> mirroringFeatures = Arrays.stream(MirroringFeature.values()).filter(MirroringFeature::isMandatory).toList();
        MirroringCapabilities capabilities = this.getCapabilities(upstreamServer);
        if (capabilities != null && !capabilities.getFeatures().containsAll(mirroringFeatures)) {
            this.addJohnsonEvent(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.capability.not.supported", new Object[]{upstreamServer.getBaseUrl(), MIN_UPSTREAM_VERSION}));
            log.warn(String.format("The upstream %s is incompatible with this version of mirrors. Please update your upstream to version %s or higher.", upstreamServer.getBaseUrl(), MIN_UPSTREAM_VERSION));
        }
    }

    @Nonnull
    private InternalUpstreamServer createSingleUpstream(@Nonnull String upstreamUrl) {
        return (InternalUpstreamServer)this.inTransaction(() -> {
            AoUpstreamServer upstream = this.upstreamServerDao.getUpstream();
            if (upstream != null) {
                throw new IllegalStateException(String.format("Upstream already registered as '%s'.", upstream.getBaseUrl()));
            }
            return this.createUpstreamInternal(upstreamUrl);
        });
    }

    private AoUpstreamServer createUpstreamInternal(@Nonnull String baseUrl) {
        String id = UUID.nameUUIDFromBytes(baseUrl.getBytes(StandardCharsets.UTF_8)).toString().toLowerCase(Locale.ROOT);
        log.debug("Creating new upstream server in database with ID {}, baseUrl {}", (Object)id, (Object)baseUrl);
        CreateUpstreamServerRequest.Builder builder = new CreateUpstreamServerRequest.Builder().id(id).baseUrl(baseUrl).state(IntegrationState.INITIALIZING);
        return this.upstreamServerDao.create(builder.build());
    }

    @Nonnull
    private String getUpstreamUrlFromPropertiesOrJohnson() {
        Optional<String> upstreamUrl = this.config.getServerUpstreamUrl();
        if (!upstreamUrl.isPresent()) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.url.not.configured", new Object[0]);
            this.addJohnsonEvent(message);
            throw new InvalidUpstreamServerUrlException(message);
        }
        String url = upstreamUrl.get();
        if (!this.isValidUrl(url)) {
            KeyedMessage message = this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.url.invalid", new Object[]{url});
            this.addJohnsonEvent(message);
            throw new InvalidUpstreamServerUrlException(message);
        }
        return upstreamUrl.get();
    }

    private AoUpstreamServer getOrCreateUpstreamServer() {
        return (AoUpstreamServer)this.transactionTemplate.execute(() -> {
            AoUpstreamServer upstreamServer = this.upstreamServerDao.getUpstream();
            if (upstreamServer == null) {
                String upstreamUrl = this.getUpstreamUrlFromPropertiesOrJohnson();
                return this.createUpstreamInternal(upstreamUrl);
            }
            return upstreamServer;
        });
    }

    private <T> T inTransaction(TransactionCallback<T> t) {
        return (T)this.transactionTemplate.execute(t);
    }

    private void inTransactionVoid(Runnable r) {
        this.inTransaction(() -> {
            r.run();
            return VOID_RESULT;
        });
    }

    private boolean isAuthenticatedAsUpstream(String upstreamId) {
        return MirroringUserUtils.isUpstreamUserFor(this.authenticationContext.getCurrentUser(), upstreamId);
    }

    private RepositorySynchronizedOnFarmEvent maybeTruncateRefs(RepositorySynchronizedOnFarmEvent event) {
        RepositorySynchronizedOnFarmEvent.Builder builder = new RepositorySynchronizedOnFarmEvent.Builder(event);
        List refChanges = event.getRefChanges().stream().filter(refChange -> !refChange.getRef().getId().startsWith(GitRefPattern.PULL_REQUESTS.getPath())).collect(Collectors.toList());
        if (refChanges.size() > this.config.getUpstreamEventRefChangeMaxSize()) {
            log.debug("{}: Truncated {} ref changes for repository with ID ({}) before notifying upstream", new Object[]{event.getRepository(), refChanges.size(), event.getExternalRepositoryId()});
            refChanges = Collections.emptyList();
            builder.refLimitExceeded(true);
        }
        return builder.refChanges(refChanges).build();
    }

    private void onStateUpdated(@Nonnull String upstreamId, IntegrationState expectedState) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        if (this.isAuthenticatedAsUpstream(upstreamId)) {
            this.setIntegrationState(upstreamId, expectedState);
        } else {
            this.refreshStateFromUpstream(this.getUpstreamOrFail(upstreamId), REFRESH_DELAY_MS);
        }
    }

    private void refreshStateFromUpstream(@Nonnull UpstreamServer upstream, long delayMs) {
        if (delayMs <= 0L) {
            this.refresh(upstream);
        } else {
            this.executorService.schedule(new DelayedRefreshStateCommand(upstream), delayMs, TimeUnit.MILLISECONDS);
        }
    }

    private NoSuchUpstreamException noSuchUpstreamException(String upstreamId) {
        return new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[]{upstreamId}));
    }

    private IncompatibleApplicationModeException notAMirrorException() {
        return new IncompatibleApplicationModeException(this.i18nService.createKeyedMessage("bitbucket.mirroring.not.a.mirror", new Object[0]));
    }

    private NoSuchUpstreamException notYetRegisteredException() {
        return new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.not.yet.registered", new Object[0]));
    }

    private IntegrationState refreshUpstreamState(@Nonnull UpstreamServer upstream) {
        try {
            if (this.upstreamClientFactory.create(upstream).isMirrorInstalled()) {
                return IntegrationState.INSTALLED;
            }
        }
        catch (Exception e) {
            log.warn("Could not retrieve mirror state at upstream server {} ({}).", new Object[]{MirrorDescriptionUtils.describe(upstream), e.getMessage(), LogUtils.logStacktraceIfEnabled(log.isDebugEnabled(), e)});
            IntegrationState curState = upstream.getState();
            return curState == IntegrationState.INITIALIZING || curState == IntegrationState.PENDING || curState == IntegrationState.REMOVED ? curState : IntegrationState.UNKNOWN;
        }
        IntegrationState currentState = upstream.getState();
        return currentState == IntegrationState.INITIALIZING || currentState == IntegrationState.PENDING || currentState == IntegrationState.REMOVED ? currentState : IntegrationState.REMOVED;
    }

    private void registerUpstream(AoUpstreamServer upstream) {
        log.info("Registering with '{}' as a mirror server", MirrorDescriptionUtils.describe(upstream));
        this.upstreamClientFactory.create(upstream).registerAsMirror(new SimpleMirroringRequest.Builder().productVersion(StringUtils.abbreviate((String)this.propertiesService.getBuildVersion(), (int)64)).mirrorServer(Objects.requireNonNull(this.config.getServerId()), StringUtils.abbreviate((String)(MIRROR_NAME_PREFIX + this.config.getDisplayName()), (int)64), this.config.getMirrorType()).mirrorBaseUrl(Objects.requireNonNull(this.propertiesService.getBaseUrl()).toASCIIString()).build());
        this.inTransactionVoid(() -> this.setIntegrationState(upstream, IntegrationState.PENDING));
    }

    @VisibleForTesting
    String getProductName() {
        return Product.NAME;
    }

    private AuthorisationException throwNotPermitted() {
        throw new AuthorisationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.operation.not.permitted", new Object[0]));
    }

    private NoSuchUpstreamException throwNoSuchUpstream(String upstreamId) {
        throw this.noSuchUpstreamException(upstreamId);
    }

    private void maybeAttemptRepublishEvent(AbstractRetryableUpstreamRepositoryEvent event, Throwable e) {
        int maxAttempts;
        int attempt = event.getAttempt();
        if (attempt < (maxAttempts = this.config.getMaxUpstreamEventPublishAttempts())) {
            log.warn("{}: Could not notify upstream that event {} for repository with ID ({}) has been raised on mirror; attempt {}/{}", new Object[]{event.getRepository(), event, event.getExternalRepositoryId(), attempt, maxAttempts});
            event.incrementAttempts();
            this.executorService.schedule(() -> this.eventPublisher.publish((Object)event), BackoffUtils.exponentialDelay(this.config.getUpstreamEventPublishInitialRetryDelay().toMillis(), attempt), TimeUnit.MILLISECONDS);
        } else {
            log.warn("{}: Given up notifying upstream that event {} for repository with ID ({}) has been raised on mirror", new Object[]{event.getRepository(), event, event.getExternalRepositoryId(), e});
        }
    }

    private InternalUpstreamServer tryGetUpstream() {
        InternalUpstreamServer upstream = this.get();
        if (upstream == null) {
            log.debug("Upstream has not yet been registered.");
            throw this.notYetRegisteredException();
        }
        return upstream;
    }

    @VisibleForTesting
    class DelayedRefreshStateCommand
    implements Callable<Void> {
        private final UpstreamServer upstream;

        public DelayedRefreshStateCommand(UpstreamServer upstream) {
            this.upstream = upstream;
        }

        @Override
        public Void call() {
            DefaultUpstreamService.this.refresh(this.upstream);
            return null;
        }
    }
}

