/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamSettingsChangedAnalyticsEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamSettingsConflictResolver;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingRequestWrapper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamSettingsOperation;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.RequestReplyTopic;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsChangedEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsGetRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsSetRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUpdateRequest;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpstreamSettingsService
implements UpstreamSettingsService {
    public static final String UPSTREAM_SETTINGS_LOCK = "upstream_settings";
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamSettingsService.class);
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final LockService lockService;
    private final TransactionTemplate transactionTemplate;
    private final UpstreamServerDao upstreamServerDao;
    private final UpstreamSettingsOperation upstreamSettingsOperation;
    private final UpstreamSettingsConflictResolver upstreamSettingsConflictResolver;
    private final RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingTopic;

    public DefaultUpstreamSettingsService(EventPublisher eventPublisher, I18nService i18nService, LockService lockService, TransactionTemplate transactionTemplate, UpstreamServerDao upstreamServerDao, UpstreamSettingsOperation upstreamSettingsOperation, UpstreamSettingsConflictResolver upstreamSettingsConflictResolver, RequestReplyTopic<UpstreamSettingRequestWrapper, UpstreamSettings> upstreamSettingTopic) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.lockService = lockService;
        this.transactionTemplate = transactionTemplate;
        this.upstreamServerDao = upstreamServerDao;
        this.upstreamSettingsOperation = upstreamSettingsOperation;
        this.upstreamSettingsConflictResolver = upstreamSettingsConflictResolver;
        this.upstreamSettingTopic = upstreamSettingTopic;
    }

    @Override
    @Nonnull
    public Optional<UpstreamSettings> getSettings(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        return Optional.ofNullable((UpstreamSettings)this.transactionTemplate.execute(() -> UpstreamSettingsUtils.toMirrorSettings(this.upstreamServerDao.getSettingsById(upstreamId))));
    }

    @Override
    @Nonnull
    public UpstreamSettings getSettingsOrFail(@Nonnull String upstreamId) {
        return this.getSettings(upstreamId).orElseThrow(() -> new IllegalStateException("Upstream " + upstreamId + " exists, but its configuration does not"));
    }

    @Override
    @Nonnull
    public UpstreamSettings setSettings(@Nonnull UpstreamSettingsSetRequest request) {
        return this.handleRequestOnCluster(request, UpstreamSettingRequestWrapper.Type.SET);
    }

    @Override
    @Nonnull
    public Optional<UpstreamSettings> syncUpstreamSettings(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        Optional<UpstreamSettings> localUpstreamSettings = this.getSettings(upstreamId);
        UpstreamSettings clusterUpstreamSettings = this.settingsOnCluster(new UpstreamSettingRequestWrapper<UpstreamSettingsGetRequest>(new UpstreamSettingsGetRequest(upstreamId), UpstreamSettingRequestWrapper.Type.GET));
        if (!(localUpstreamSettings.isPresent() && clusterUpstreamSettings.equals(localUpstreamSettings.get()) || clusterUpstreamSettings.isBlank())) {
            return Optional.of(this.upstreamSettingsOperation.perform(new UpstreamSettingRequestWrapper<UpstreamSettingsSetRequest>(new UpstreamSettingsSetRequest.Builder(upstreamId).mode(clusterUpstreamSettings.getMode()).projectIds(clusterUpstreamSettings.getMirroredProjectIds()).build(), UpstreamSettingRequestWrapper.Type.SET)));
        }
        return localUpstreamSettings;
    }

    @Override
    @Nonnull
    public UpstreamSettings updateSettings(@Nonnull UpstreamSettingsUpdateRequest request) {
        return this.handleRequestOnCluster(request, UpstreamSettingRequestWrapper.Type.UPDATE);
    }

    private <T extends UpstreamSettingsRequest> UpstreamSettings handleRequestOnCluster(@Nonnull T request, @Nonnull UpstreamSettingRequestWrapper.Type type) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(type, "type");
        String upstreamId = request.getUpstreamId();
        AoUpstreamServer upstreamServer = this.upstreamServerDao.getById(upstreamId);
        if (upstreamServer == null) {
            throw this.newNoSuchUpstream(upstreamId);
        }
        UpstreamSettings oldSettings = UpstreamSettingsUtils.toMirrorSettings(this.upstreamServerDao.getSettingsById(upstreamId));
        UpstreamSettings newSettings = this.settingsOnCluster(new UpstreamSettingRequestWrapper<T>(request, type));
        if (!newSettings.equals(oldSettings)) {
            UpstreamSettingsChangedEvent upstreamSettingsChangedEvent = new UpstreamSettingsChangedEvent(this, upstreamServer, oldSettings, newSettings);
            this.eventPublisher.publish((Object)upstreamSettingsChangedEvent);
            this.eventPublisher.publish((Object)new UpstreamSettingsChangedAnalyticsEvent(this, upstreamSettingsChangedEvent));
        }
        return newSettings;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    private UpstreamSettings settingsOnCluster(@Nonnull UpstreamSettingRequestWrapper wrapper) {
        Objects.requireNonNull(wrapper, "wrapper");
        Lock lock = this.lockService.getLock(UPSTREAM_SETTINGS_LOCK);
        try (LockGuard lockGuard = LockGuard.tryLock((Lock)lock, (long)5L, (TimeUnit)TimeUnit.MINUTES);){
            if (lockGuard != null) {
                try {
                    UpstreamSettings upstreamSettings = this.upstreamSettingTopic.publish(wrapper, this.upstreamSettingsConflictResolver);
                    return upstreamSettings;
                }
                catch (Exception e) {
                    SimpleUpstreamSettings simpleUpstreamSettings;
                    block13: {
                        log.warn("Failed to execute upstream setting operation", e.getCause());
                        simpleUpstreamSettings = SimpleUpstreamSettings.blank();
                        if (lockGuard == null) break block13;
                        lockGuard.close();
                    }
                    return simpleUpstreamSettings;
                }
            }
            SimpleUpstreamSettings simpleUpstreamSettings = SimpleUpstreamSettings.blank();
            return simpleUpstreamSettings;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return SimpleUpstreamSettings.blank();
        }
    }

    private NoSuchUpstreamException newNoSuchUpstream(String upstreamId) {
        return new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[]{upstreamId}));
    }
}

