/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.NoSuchUserException;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.bitbucket.user.ServiceUserCreateRequest;
import com.atlassian.bitbucket.user.ServiceUserUpdateRequest;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Operation;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultUpstreamUserHelper
implements UpstreamUserHelper {
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamUserHelper.class);
    private static final String UPSTREAM_MIRROR_USER_LABEL = "mirroring:upstream";
    private final SecurityService securityService;
    private final UserService userService;
    private final I18nService i18nService;
    private final UserAdminService userAdminService;

    @Autowired
    public DefaultUpstreamUserHelper(I18nService i18nService, SecurityService securityService, UserAdminService userAdminService, UserService userService) {
        this.i18nService = i18nService;
        this.userAdminService = userAdminService;
        this.userService = userService;
        this.securityService = securityService;
    }

    @Override
    @Nonnull
    public ServiceUser createNewOrActivateExistingUserForUpstream(@Nonnull String upstreamId) {
        ServiceUser serviceUser = this.getUserForUpstream(upstreamId);
        serviceUser = serviceUser != null ? this.setServiceUserEnabled(serviceUser, true) : this.createUserForUpstream(upstreamId);
        return serviceUser;
    }

    @Override
    @Nonnull
    public ServiceUser createUserForUpstream(@Nonnull String upstreamId) {
        return this.userAdminService.createServiceUser(((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)((ServiceUserCreateRequest.Builder)new ServiceUserCreateRequest.Builder().active(true)).name(MirroringUserUtils.getUpstreamUsernameFor(upstreamId))).displayName("Upstream mirror service user for " + upstreamId)).label(UPSTREAM_MIRROR_USER_LABEL)).build());
    }

    @Override
    public ServiceUser deactivateUserForUpstream(@Nonnull String upstreamId) {
        ServiceUser serviceUser = this.getUserForUpstream(upstreamId);
        if (serviceUser != null) {
            return this.setServiceUserEnabled(serviceUser, false);
        }
        log.warn("Service user expected but not found for upstream mirror {}", (Object)upstreamId);
        return null;
    }

    @Override
    public ServiceUser getUserForUpstream(@Nonnull String upstreamId) {
        return this.userService.getServiceUserByName(MirroringUserUtils.getUpstreamUsernameFor(upstreamId), true);
    }

    @Override
    public EscalatedSecurityContext asUserForUpstream(@Nonnull String upstreamId) {
        ServiceUser upstreamUser = this.getUserForUpstream(upstreamId);
        if (upstreamUser != null) {
            return this.securityService.impersonating((ApplicationUser)upstreamUser, "For mirroring");
        }
        return null;
    }

    @Override
    @Nonnull
    public <R> R performAsUpstreamUser(@Nonnull String upstreamId, @Nonnull Operation<R, RuntimeException> operation) {
        Objects.requireNonNull(upstreamId);
        Objects.requireNonNull(operation);
        EscalatedSecurityContext escalatedSecurityContext = this.asUserForUpstream(upstreamId);
        if (escalatedSecurityContext != null) {
            return (R)escalatedSecurityContext.withPermission(Permission.ADMIN).call(operation);
        }
        throw new NoSuchUserException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.service.user", new Object[]{upstreamId}), upstreamId);
    }

    private ServiceUser setServiceUserEnabled(ServiceUser serviceUser, boolean enabled) {
        if (serviceUser.isActive() == enabled) {
            return serviceUser;
        }
        return this.userAdminService.updateServiceUser(((ServiceUserUpdateRequest.Builder)new ServiceUserUpdateRequest.Builder(serviceUser).active(enabled)).build());
    }
}

