/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.MinimalExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.repository.MirrorRepository;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import jakarta.annotation.Nonnull;

public class MirrorDescriptionUtils {
    private MirrorDescriptionUtils() {
    }

    public static Object describe(final @Nonnull UpstreamServer upstream) {
        return new Object(){

            public String toString() {
                return "[" + upstream.getBaseUrl() + "]";
            }
        };
    }

    public static Object describe(final @Nonnull ExternalProject project) {
        return new Object(){

            public String toString() {
                return String.format("[%s](%s)", project.getKey(), project.getId());
            }
        };
    }

    public static Object describe(final @Nonnull MirrorRepository repository) {
        return new Object(){

            public String toString() {
                return String.format("[%s/%s](%s)", repository.getProject() == null ? "???" : repository.getProject().getKey(), repository.getSlug(), repository.getId());
            }
        };
    }

    public static Object describe(final @Nonnull MinimalExternalRepository repository) {
        return new Object(){

            public String toString() {
                return String.format("[%s/%s](%s)", repository.getProject() == null ? "???" : repository.getProject().getKey(), repository.getSlug(), repository.getId());
            }
        };
    }
}

