/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.dmz.mirror.DmzMirrorFarm;
import com.atlassian.bitbucket.dmz.mirror.SynchronizationState;
import com.atlassian.bitbucket.internal.mirroring.mirror.FarmVet;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.FullSyncStateManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.synchronization.InitialSyncHelper;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorSynchronizationJobRunner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(MirrorSynchronizationJobRunner.class);
    private final MirroringConfig config;
    private final FarmVet farmVet;
    private final FullSyncStateManager fullSyncStateManager;
    private final DmzMirrorFarm mirrorFarm;
    private final InitialSyncHelper initialSyncHelper;
    private final InternalUpstreamService upstreamService;
    private final UpstreamUserHelper upstreamUserHelper;
    private volatile Instant capabilitiesRefreshed;
    private volatile Instant fullSynchronization;

    public MirrorSynchronizationJobRunner(MirroringConfig config, FarmVet farmVet, FullSyncStateManager fullSyncStateManager, DmzMirrorFarm mirrorFarm, InitialSyncHelper initialSyncHelper, InternalUpstreamService upstreamService, UpstreamUserHelper upstreamUserHelper) {
        this.config = config;
        this.farmVet = farmVet;
        this.fullSyncStateManager = fullSyncStateManager;
        this.mirrorFarm = mirrorFarm;
        this.initialSyncHelper = initialSyncHelper;
        this.upstreamService = upstreamService;
        this.upstreamUserHelper = upstreamUserHelper;
        this.capabilitiesRefreshed = this.fullSynchronization = Instant.EPOCH;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        InternalUpstreamServer upstreamServer = this.upstreamService.get();
        if (upstreamServer == null || EnumSet.of(IntegrationState.INITIALIZING, IntegrationState.PENDING).contains((Object)upstreamServer.getState())) {
            log.debug("Not registered with an upstream; nothing to do");
        } else if (upstreamServer.getState() == IntegrationState.INSTALLED) {
            this.runTasks(upstreamServer);
        } else {
            this.upstreamService.refresh(upstreamServer);
        }
        return JobRunnerResponse.success();
    }

    private void runTasks(UpstreamServer upstreamServer) {
        boolean synchronize;
        Instant start = Instant.now();
        boolean refreshCapabilities = start.isAfter(this.capabilitiesRefreshed.plus(this.config.getCapabilitiesRefreshInterval()));
        boolean runFullSync = !this.fullSyncStateManager.isFullSyncComplete();
        boolean bl = synchronize = !runFullSync && upstreamServer.getLastFullSyncDate() != null && this.mirrorFarm.getSynchronizationState() == SynchronizationState.SYNCHRONIZED && start.isAfter(this.fullSynchronization.plus(this.config.getSyncInterval()));
        if ((refreshCapabilities || synchronize || runFullSync) && (upstreamServer = this.upstreamService.refresh(upstreamServer)).getState() != IntegrationState.INSTALLED) {
            return;
        }
        if (refreshCapabilities) {
            this.upstreamService.refreshCapabilities(upstreamServer);
            this.capabilitiesRefreshed = Instant.now();
        }
        if (runFullSync) {
            log.debug("(Re) doing full sync operation");
            this.upstreamUserHelper.performAsUpstreamUser(upstreamServer.getId(), () -> {
                this.initialSyncHelper.triggerFullSync();
                return null;
            });
        }
        if (synchronize) {
            log.debug("Running farm vet");
            this.farmVet.synchronize(upstreamServer, false);
            this.fullSynchronization = Instant.now();
        }
    }
}

