/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorSynchronizationJobRunner;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.mirroring.mirror.AbstractEagerlyRegisteringLifecycleAware;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.time.Duration;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirrorSynchronizationScheduler
extends AbstractEagerlyRegisteringLifecycleAware {
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)MirrorSynchronizationJobRunner.class.getName());
    private static final Logger log = LoggerFactory.getLogger(MirrorSynchronizationScheduler.class);
    private final MirroringConfig config;
    private final JobRunner mirrorSynchronizationJobRunner;
    private final SchedulerService schedulerService;

    public MirrorSynchronizationScheduler(MirroringConfig config, PluginEventManager pluginEventManager, SchedulerService schedulerService, JobRunner mirrorSynchronizationJobRunner) {
        super(pluginEventManager);
        this.config = config;
        this.mirrorSynchronizationJobRunner = mirrorSynchronizationJobRunner;
        this.schedulerService = schedulerService;
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, request -> {
            try {
                JobRunnerResponse jobRunnerResponse = this.mirrorSynchronizationJobRunner.runJob(request);
                return jobRunnerResponse;
            }
            catch (RuntimeException e) {
                JobRunnerResponse jobRunnerResponse = JobRunnerResponse.failed((Throwable)e);
                return jobRunnerResponse;
            }
            finally {
                this.scheduleJob(this.config.getStateRefreshInterval());
            }
        });
        this.scheduleJob(this.config.getSyncInitialDelay());
    }

    @Override
    public void onStop() {
        this.schedulerService.getJobsByJobRunnerKey(JOB_RUNNER_KEY).forEach(job -> this.schedulerService.unscheduleJob(job.getJobId()));
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    private void scheduleJob(Duration delay) {
        try {
            this.schedulerService.scheduleJobWithGeneratedId(JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce((Date)new Date(System.currentTimeMillis() + delay.toMillis()))));
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule synchronization", (Throwable)e);
        }
    }
}

