/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserType;
import jakarta.annotation.Nonnull;

public class MirroringUserUtils {
    private static final String PREFIX_UPSTREAM_USERNAME = "upstream_";

    private MirroringUserUtils() {
    }

    @Nonnull
    public static String getUpstreamUsernameFor(@Nonnull String upstreamId) {
        return PREFIX_UPSTREAM_USERNAME + upstreamId;
    }

    public static boolean isUpstreamUsername(@Nonnull String name) {
        return name.startsWith(PREFIX_UPSTREAM_USERNAME);
    }

    public static boolean isUpstreamUser(ApplicationUser user) {
        return user != null && user.getType() == UserType.SERVICE && MirroringUserUtils.isUpstreamUsername(user.getName());
    }

    public static boolean isUpstreamUserFor(ApplicationUser user, @Nonnull String upstreamId) {
        return MirroringUserUtils.isUpstreamUser(user) && MirroringUserUtils.getUpstreamUsernameFor(upstreamId).equals(user.getName());
    }
}

