/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class MirroringValidationHelper {
    private final MirrorAuthenticationContext mirrorAuthenticationContext;
    private final PermissionValidationService permissionValidationService;

    @Autowired
    public MirroringValidationHelper(@Qualifier(value="defaultMirrorAuthenticationContext") MirrorAuthenticationContext mirrorAuthenticationContext, PermissionValidationService permissionValidationService) {
        this.mirrorAuthenticationContext = mirrorAuthenticationContext;
        this.permissionValidationService = permissionValidationService;
    }

    public void checkIsUpstreamUserOrAdmin(@Nonnull String upstreamId) {
        if (!this.isAuthenticatedAsUpstream(upstreamId)) {
            this.permissionValidationService.validateForGlobal(Permission.ADMIN);
        }
    }

    private boolean isAuthenticatedAsUpstream(String upstreamId) {
        return this.mirrorAuthenticationContext.getCurrentUpstreamUser().map(user -> MirroringUserUtils.isUpstreamUserFor((ApplicationUser)user, upstreamId)).orElse(false);
    }
}

