/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.InvalidObjectException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class SimpleInternalUpstreamServer
implements InternalUpstreamServer,
Serializable {
    private final String baseUrl;
    private final String id;
    private final String issuerId;
    private final String sharedSecret;
    private final IntegrationState state;
    private String handshakeId;
    private Date lastFullSyncDate;
    private Date lastSettingsChangeDate;
    private Date lastStateChangeDate;

    private SimpleInternalUpstreamServer(Builder builder) {
        this.baseUrl = Objects.requireNonNull(builder.baseUrl, "baseUrl");
        this.id = Objects.requireNonNull(builder.id, "id");
        this.handshakeId = builder.handshakeId;
        this.issuerId = builder.issuerId;
        this.lastFullSyncDate = builder.lastFullSyncDate;
        this.lastSettingsChangeDate = builder.lastSettingsChangeDate;
        this.lastStateChangeDate = Objects.requireNonNull(builder.lastStateChangeDate, "lastStateChangeDate");
        this.sharedSecret = builder.sharedSecret;
        this.state = Objects.requireNonNull(builder.state, "state");
    }

    @Override
    @Nonnull
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    @Nonnull
    public Optional<String> getHandshakeId() {
        return Optional.ofNullable(this.handshakeId);
    }

    @Override
    @Nonnull
    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Optional<String> getIssuerId() {
        return Optional.ofNullable(this.issuerId);
    }

    @Override
    @Nullable
    public Date getLastFullSyncDate() {
        return this.lastFullSyncDate;
    }

    @Override
    @Nullable
    public Date getLastSettingsChangeDate() {
        return this.lastSettingsChangeDate;
    }

    @Override
    @Nonnull
    public Date getLastStateChangeDate() {
        return this.lastStateChangeDate;
    }

    @Override
    @Nonnull
    public Optional<String> getSharedSecret() {
        return Optional.ofNullable(this.sharedSecret);
    }

    @Override
    @Nonnull
    public IntegrationState getState() {
        return this.state;
    }

    @Override
    public void setHandshakeId(@Nullable String handshakeId) {
        this.handshakeId = handshakeId;
    }

    @Override
    public void setLastSettingsChangeDate(@Nullable Date lastSettingsChangeDate) {
        this.lastSettingsChangeDate = lastSettingsChangeDate;
    }

    @Override
    public void setLastStateChangeDate(@Nonnull Date lastStateChangeDate) {
        this.lastStateChangeDate = Objects.requireNonNull(lastStateChangeDate, "lastStateChangeDate");
    }

    @Override
    public void setLastFullSyncDate(@Nullable Date lastFullSyncDate) {
        this.lastFullSyncDate = lastFullSyncDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("baseUrl", (Object)this.baseUrl).add("state", (Object)this.state).add("issuerId", (Object)this.issuerId).add("lastSettingsChangeDate", (Object)this.lastSettingsChangeDate).add("lastStateChangeDate", (Object)this.lastStateChangeDate).add("lastFullSyncDate", (Object)this.lastFullSyncDate).add("handshakeId", (Object)this.handshakeId).toString();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInternalUpstreamServer that = (SimpleInternalUpstreamServer)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.issuerId, that.issuerId) && Objects.equals(this.sharedSecret, that.sharedSecret) && Objects.equals(this.handshakeId, that.handshakeId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.baseUrl, this.state, this.issuerId, this.sharedSecret, this.handshakeId});
    }

    private Object writeReplace() {
        return new InternalUpstreamServerSerializationProxy(this);
    }

    public static class Builder {
        private String baseUrl;
        private String handshakeId;
        private String id;
        private String issuerId;
        private Date lastFullSyncDate;
        private Date lastSettingsChangeDate;
        private Date lastStateChangeDate;
        private String sharedSecret;
        private IntegrationState state;

        public Builder() {
            this.issuerId = null;
            this.sharedSecret = null;
        }

        public Builder(@Nonnull InternalUpstreamServer upstreamServer) {
            Objects.requireNonNull(upstreamServer, "upstreamServer");
            this.baseUrl(upstreamServer.getBaseUrl());
            this.handshakeId(upstreamServer.getHandshakeId().orElse(null));
            this.id(upstreamServer.getId());
            this.issuerId(upstreamServer.getIssuerId().orElse(null));
            this.lastFullSyncDate(upstreamServer.getLastFullSyncDate());
            this.lastSettingsChangeDate(upstreamServer.getLastSettingsChangeDate());
            this.sharedSecret(upstreamServer.getSharedSecret().orElse(null));
            this.state(upstreamServer.getState(), upstreamServer.getLastStateChangeDate());
        }

        @Nonnull
        public Builder baseUrl(@Nonnull String value) {
            this.baseUrl = Objects.requireNonNull(value, "baseUrl");
            return this;
        }

        @Nonnull
        public Builder handshakeId(@Nullable String value) {
            this.handshakeId = value;
            return this;
        }

        @Nonnull
        public Builder id(@Nonnull String value) {
            this.id = Objects.requireNonNull(value, "id");
            return this;
        }

        @Nonnull
        public Builder issuerId(String value) {
            this.issuerId = value;
            return this;
        }

        @Nonnull
        public Builder lastFullSyncDate(@Nullable Date value) {
            this.lastFullSyncDate = value;
            return this;
        }

        @Nonnull
        public Builder lastSettingsChangeDate(@Nullable Date value) {
            this.lastSettingsChangeDate = value;
            return this;
        }

        @Nonnull
        public Builder sharedSecret(String value) {
            this.sharedSecret = value;
            return this;
        }

        @Nonnull
        public Builder state(@Nonnull IntegrationState value, @Nonnull Date when) {
            this.state = Objects.requireNonNull(value, "state");
            this.lastStateChangeDate = Objects.requireNonNull(when, "when");
            return this;
        }

        @Nonnull
        public Builder withDefaults() {
            return this.baseUrl("https://www.example.com").id(UUID.randomUUID().toString()).issuerId("issuerId").lastFullSyncDate(new Date()).lastSettingsChangeDate(new Date()).state(IntegrationState.INSTALLED, new Date());
        }

        @Nonnull
        public SimpleInternalUpstreamServer build() {
            return new SimpleInternalUpstreamServer(this);
        }
    }

    private static class InternalUpstreamServerSerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 795650959570009407L;
        private final String baseUrl;
        private final String handshakeId;
        private final String id;
        private final String issuerId;
        private final Date lastFullSyncDate;
        private final Date lastSettingsChangeDate;
        private final Date lastStateChangeDate;
        private final IntegrationState state;
        private final String sharedSecret;

        private InternalUpstreamServerSerializationProxy(SimpleInternalUpstreamServer internalUpstreamServer) {
            this.baseUrl = internalUpstreamServer.getBaseUrl();
            this.handshakeId = internalUpstreamServer.getHandshakeId().orElse(null);
            this.id = internalUpstreamServer.getId();
            this.issuerId = internalUpstreamServer.getIssuerId().orElse(null);
            this.lastFullSyncDate = internalUpstreamServer.getLastFullSyncDate();
            this.lastSettingsChangeDate = internalUpstreamServer.getLastSettingsChangeDate();
            this.lastStateChangeDate = internalUpstreamServer.getLastStateChangeDate();
            this.state = internalUpstreamServer.getState();
            this.sharedSecret = internalUpstreamServer.getSharedSecret().orElse(null);
        }

        public Object readResolve() throws InvalidObjectException {
            return new Builder().baseUrl(this.baseUrl).handshakeId(this.handshakeId).id(this.id).issuerId(this.issuerId).lastFullSyncDate(this.lastFullSyncDate).lastSettingsChangeDate(this.lastSettingsChangeDate).state(this.state, this.lastStateChangeDate).sharedSecret(this.sharedSecret).build();
        }
    }
}

