/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.mirroring.mirror.MirroredRepository;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryStatus;
import com.atlassian.bitbucket.util.NamedLink;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleMirroredRepository
implements MirroredRepository {
    private final Set<NamedLink> cloneUrls;
    private final Date lastUpdated;
    private final String mirrorName;
    private final Set<NamedLink> pushUrls;
    private final String repositoryId;
    private final MirroredRepositoryStatus status;

    private SimpleMirroredRepository(Builder builder) {
        this.cloneUrls = builder.cloneUrls.build();
        this.lastUpdated = builder.lastUpdated;
        this.mirrorName = Objects.requireNonNull(builder.mirrorName, "mirrorName");
        this.pushUrls = builder.pushUrls.build();
        this.repositoryId = Objects.requireNonNull(builder.repositoryId, "repositoryId");
        this.status = Objects.requireNonNull(builder.status, "status");
    }

    @Override
    @Nonnull
    public Set<NamedLink> getCloneUrls() {
        return this.cloneUrls;
    }

    @Override
    @Nonnull
    public String getMirrorName() {
        return this.mirrorName;
    }

    @Override
    @Nonnull
    public Optional<Date> getLastUpdated() {
        return Optional.ofNullable(this.lastUpdated);
    }

    @Override
    @Nonnull
    public Set<NamedLink> getPushUrls() {
        return this.pushUrls;
    }

    @Override
    @Nonnull
    public String getRepositoryId() {
        return this.repositoryId;
    }

    @Override
    public boolean isAvailable() {
        return this.status == MirroredRepositoryStatus.AVAILABLE || this.status == MirroredRepositoryStatus.ERROR_AVAILABLE;
    }

    @Override
    @Nonnull
    public MirroredRepositoryStatus getStatus() {
        return this.status;
    }

    public static class Builder {
        private final ImmutableSet.Builder<NamedLink> cloneUrls = ImmutableSet.builder();
        private final ImmutableSet.Builder<NamedLink> pushUrls = ImmutableSet.builder();
        private Date lastUpdated;
        private String mirrorName;
        private String repositoryId;
        private MirroredRepositoryStatus status;

        public Builder status(@Nonnull MirroredRepositoryStatus value) {
            Objects.requireNonNull(value, "status");
            this.status = value;
            return this;
        }

        public Builder cloneUrl(@Nonnull NamedLink value) {
            Objects.requireNonNull(value, "cloneUrl");
            this.cloneUrls.add((Object)value);
            return this;
        }

        public Builder cloneUrls(@Nonnull Iterable<NamedLink> value) {
            Objects.requireNonNull(value, "cloneUrls");
            this.cloneUrls.addAll(value);
            return this;
        }

        public Builder lastUpdated(@Nullable Date value) {
            this.lastUpdated = value;
            return this;
        }

        public Builder mirrorName(@Nonnull String value) {
            Objects.requireNonNull(value, "mirrorName");
            this.mirrorName = value;
            return this;
        }

        public Builder pushUrl(@Nonnull NamedLink value) {
            Objects.requireNonNull(value, "pushUrl");
            this.pushUrls.add((Object)value);
            return this;
        }

        public Builder pushUrls(@Nonnull Iterable<NamedLink> value) {
            Objects.requireNonNull(value, "pushUrls");
            this.pushUrls.addAll(value);
            return this;
        }

        public Builder repositoryId(@Nonnull String value) {
            Objects.requireNonNull(value, "repositoryId");
            this.repositoryId = value;
            return this;
        }

        public SimpleMirroredRepository build() {
            return new SimpleMirroredRepository(this);
        }
    }
}

