/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SimpleUpstreamSettings
implements UpstreamSettings {
    private final MirroringMode mode;
    private final Set<String> projectIds;
    private final Date lastUpdatedTime;

    private SimpleUpstreamSettings(Builder builder) {
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.mode = builder.mode;
        this.projectIds = builder.projectIdsBuilder.build();
        Preconditions.checkArgument((this.mode == MirroringMode.SELECTED_PROJECTS || this.projectIds.isEmpty() ? 1 : 0) != 0, (Object)("Specifying projects is not supported in '" + String.valueOf((Object)this.mode) + "' mirroring mode"));
    }

    @Nonnull
    public static SimpleUpstreamSettings blank() {
        return new Builder().mode(MirroringMode.SELECTED_PROJECTS).build();
    }

    @Override
    @Nonnull
    public Optional<Date> getLastUpdatedTime() {
        return Optional.ofNullable(this.lastUpdatedTime);
    }

    @Override
    @Nonnull
    public MirroringMode getMode() {
        return this.mode;
    }

    @Override
    @Nonnull
    public Set<String> getMirroredProjectIds() {
        return this.projectIds;
    }

    @Override
    public boolean isBlank() {
        return this.mode == MirroringMode.SELECTED_PROJECTS && this.projectIds.isEmpty();
    }

    @Override
    public boolean isMirrored(@Nonnull String projectId) {
        return this.mode == MirroringMode.ALL_PROJECTS || this.projectIds.contains(projectId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleUpstreamSettings that = (SimpleUpstreamSettings)o;
        return Objects.equals((Object)this.mode, (Object)that.mode) && Objects.equals(this.projectIds, that.projectIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.projectIds});
    }

    public String toString() {
        MoreObjects.ToStringHelper stringHelper = MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode);
        if (this.mode != MirroringMode.ALL_PROJECTS) {
            stringHelper.add("projectIds", this.projectIds);
        }
        return stringHelper.toString();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> projectIdsBuilder = ImmutableSet.builder();
        private MirroringMode mode = MirroringMode.ALL_PROJECTS;
        private Date lastUpdatedTime;

        @Nonnull
        public SimpleUpstreamSettings build() {
            return new SimpleUpstreamSettings(this);
        }

        @Nonnull
        public Builder lastUpdatedTime(@Nonnull Date lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Nonnull
        public Builder mode(@Nonnull MirroringMode value) {
            this.mode = Objects.requireNonNull(value, "mode");
            return this;
        }

        @Nonnull
        public Builder projectIds(@Nonnull Iterable<String> values) {
            this.projectIdsBuilder.addAll(Objects.requireNonNull(values, "projectIds"));
            return this;
        }
    }
}

