/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UpstreamInstallationParameters {
    private final String handshakeId;
    private final String issuerId;
    private final String secret;

    private UpstreamInstallationParameters(Builder builder) {
        Preconditions.checkState((builder.issuerId != null ? 1 : 0) != 0, (Object)"issuerId");
        Preconditions.checkState((builder.secret != null ? 1 : 0) != 0, (Object)"secret");
        this.handshakeId = builder.handshakeId;
        this.issuerId = builder.issuerId;
        this.secret = builder.secret;
    }

    @Nullable
    public String getHandshakeId() {
        return this.handshakeId;
    }

    @Nonnull
    public String getIssuerId() {
        return this.issuerId;
    }

    @Nonnull
    public String getSecret() {
        return this.secret;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("issuerId", (Object)this.issuerId).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpstreamInstallationParameters that = (UpstreamInstallationParameters)o;
        return Objects.equals(this.issuerId, that.issuerId) && Objects.equals(this.secret, that.secret);
    }

    public int hashCode() {
        return Objects.hash(this.issuerId, this.secret);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String handshakeId;
        private String issuerId;
        private String secret;

        @Nonnull
        public UpstreamInstallationParameters build() {
            return new UpstreamInstallationParameters(this);
        }

        @Nonnull
        public Builder handshakeId(@Nullable String handshakeId) {
            this.handshakeId = handshakeId;
            return this;
        }

        @Nonnull
        public Builder issuerId(@Nonnull String value) {
            this.issuerId = Objects.requireNonNull(StringUtils.stripToNull((String)value), "issuerId");
            return this;
        }

        @Nonnull
        public Builder secret(@Nonnull String value) {
            this.secret = Objects.requireNonNull(StringUtils.stripToNull((String)value), "secret");
            return this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("issuerId", (Object)this.issuerId).add("secret", (Object)this.secret).toString();
        }
    }
}

