/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorConstants;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestNotSupportedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.mdc.StateGeneratingJobRunner;
import com.atlassian.bitbucket.mirroring.mirror.AbstractEagerlyRegisteringLifecycleAware;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.MirrorRemovedUpstreamEvent;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.event.api.EventListener;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamRegistrationJob
extends AbstractEagerlyRegisteringLifecycleAware {
    static final JobId UPSTREAM_REGISTRATION_JOB_ID = JobId.of((String)RegistrationJobRunner.class.getSimpleName());
    static final JobRunnerKey UPSTREAM_REGISTRATION_JOB_RUNNER_KEY = JobRunnerKey.of((String)RegistrationJobRunner.class.getName());
    static final String UPSTREAM_REGISTRATION_LOCK = "upstream_registration";
    private static final List<String> JOHNSONED_EVENT_LEVELS = ImmutableList.of((Object)"error", (Object)"fatal");
    private static final Logger log = LoggerFactory.getLogger(UpstreamRegistrationJob.class);
    private final ClusterService clusterService;
    private final LockService lockService;
    private final ApplicationPropertiesService propertiesService;
    private final SchedulerService schedulerService;
    private final InternalUpstreamService upstreamService;
    private volatile boolean johnsoned;

    public UpstreamRegistrationJob(ClusterService clusterService, LockService lockService, InternalUpstreamService upstreamService, PluginEventManager pluginEventManager, ApplicationPropertiesService propertiesService, SchedulerService schedulerService) {
        super(pluginEventManager);
        this.clusterService = clusterService;
        this.lockService = lockService;
        this.propertiesService = propertiesService;
        this.schedulerService = schedulerService;
        this.upstreamService = upstreamService;
    }

    @EventListener
    public void onJohnson(AddEvent johnsonEvent) {
        if (this.johnsoned) {
            return;
        }
        if (JOHNSONED_EVENT_LEVELS.contains(johnsonEvent.getEvent().getLevel().getLevel())) {
            this.johnsoned = true;
            this.unregisterJobRunner();
        }
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.registerJobRunner();
    }

    @EventListener
    public void onMirrorRemoved(MirrorRemovedUpstreamEvent ignored) {
        this.registerJobRunner();
    }

    @Override
    public void onStop() {
        this.unregisterJobRunner();
    }

    private void registerJobRunner() {
        if (!this.johnsoned && this.upstreamService.isMirror()) {
            RegistrationJobRunner runner = new RegistrationJobRunner();
            this.schedulerService.registerJobRunner(UPSTREAM_REGISTRATION_JOB_RUNNER_KEY, (JobRunner)new StateGeneratingJobRunner(this.clusterService, runner));
            runner.schedule();
        }
    }

    private void registerOrUpgrade() {
        block13: {
            if (!this.upstreamService.isMirror()) {
                return;
            }
            Lock lock = this.lockService.getLock(UPSTREAM_REGISTRATION_LOCK);
            try (LockGuard lockGuard = LockGuard.tryLock((Lock)lock);){
                if (lockGuard != null) {
                    InternalUpstreamServer upstream = this.upstreamService.get();
                    if (upstream == null || upstream.getState() == IntegrationState.INITIALIZING || upstream.getState() == IntegrationState.REMOVED) {
                        this.upstreamService.register();
                        upstream = this.upstreamService.get();
                        log.info("Registered with {} as a mirror server", (Object)(upstream != null ? upstream.getBaseUrl() : "unknown"));
                    } else if (upstream.getState() == IntegrationState.INSTALLED || upstream.getState() == IntegrationState.UNKNOWN) {
                        try {
                            this.upstreamService.upgrade(upstream);
                            log.info("Upgraded mirror in {}", (Object)upstream.getBaseUrl());
                        }
                        catch (UpstreamRequestNotSupportedException e) {
                            log.debug("Upstream {} does not support upgrading of the mirror. Skipping", (Object)upstream.getBaseUrl());
                        }
                    }
                    break block13;
                }
                throw new RuntimeException("Failed to acquire lock upstream_registration");
            }
        }
    }

    private void unregisterJobRunner() {
        this.schedulerService.unregisterJobRunner(UPSTREAM_REGISTRATION_JOB_RUNNER_KEY);
    }

    private class RegistrationJobRunner
    implements JobRunner {
        private final double expFactor;
        private final long maxDelay;
        private long delayMs;

        RegistrationJobRunner() {
            this.delayMs = UpstreamRegistrationJob.this.propertiesService.getPluginProperty("plugin.mirroring.upstream.registration.retry.interval", MirrorConstants.DEFAULT_UPSTREAM_REGO_RETRY_INTERVAL_MS);
            this.expFactor = UpstreamRegistrationJob.this.propertiesService.getPluginProperty("plugin.mirroring.upstream.registration.retry.backoff.factor", 1.3);
            this.maxDelay = UpstreamRegistrationJob.this.propertiesService.getPluginProperty("plugin.mirroring.upstream.registration.retry.max.interval", MirrorConstants.DEFAULT_UPSTREAM_REGO_RETRY_MAX_INTERVAL_MS);
        }

        public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
            try {
                if (UpstreamRegistrationJob.this.propertiesService.isSetup()) {
                    UpstreamRegistrationJob.this.registerOrUpgrade();
                    UpstreamRegistrationJob.this.schedulerService.unscheduleJob(UPSTREAM_REGISTRATION_JOB_ID);
                }
            }
            catch (Exception e) {
                log.warn("Registration with upstream server failed ({}). Retrying in {}s", MoreObjects.firstNonNull((Object)e.getMessage(), (Object)"no message"), (Object)TimeUnit.MILLISECONDS.toSeconds(this.delayMs));
                log.debug("Registration error:", (Throwable)e);
                this.delayMs = Math.min(this.maxDelay, Math.round(this.expFactor * (double)this.delayMs));
                this.schedule();
            }
            return JobRunnerResponse.success();
        }

        private void schedule() {
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(14, Ints.saturatedCast((long)this.delayMs));
            try {
                UpstreamRegistrationJob.this.schedulerService.scheduleJob(UPSTREAM_REGISTRATION_JOB_ID, JobConfig.forJobRunnerKey((JobRunnerKey)UPSTREAM_REGISTRATION_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)this.delayMs, (Date)cal.getTime())));
            }
            catch (SchedulerServiceException e) {
                log.error("Failed to schedule mirror registration job", (Throwable)e);
            }
        }
    }
}

