/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsChangedEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;

@AsynchronousPreferred
@EventName(value="stash.mirror.upstream.settings.changed")
public class UpstreamSettingsChangedAnalyticsEvent
extends ApplicationEvent {
    private final int changedProjects;
    private final String mirroringMode;
    private final int numberOfProjects;

    protected UpstreamSettingsChangedAnalyticsEvent(@Nonnull Object source, @Nonnull UpstreamSettingsChangedEvent upstreamSettingsChangedEvent) {
        super(source);
        this.mirroringMode = upstreamSettingsChangedEvent.getNewSettings().getMode().getId();
        this.changedProjects = upstreamSettingsChangedEvent.getOldSettings() == null ? upstreamSettingsChangedEvent.getNewSettings().getMirroredProjectIds().size() : upstreamSettingsChangedEvent.getNewSettings().getMirroredProjectIds().size() - upstreamSettingsChangedEvent.getOldSettings().getMirroredProjectIds().size();
        this.numberOfProjects = upstreamSettingsChangedEvent.getNewSettings().getMirroredProjectIds().size();
    }

    public int getChangedProjects() {
        return this.changedProjects;
    }

    @Nonnull
    public String getMirroringMode() {
        return this.mirroringMode;
    }

    public int getNumberOfProjects() {
        return this.numberOfProjects;
    }
}

