/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleUpstreamSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.mirroring.mirror.MirroringMode;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import java.util.Comparator;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpstreamSettingsConflictResolver
implements ResultVisitor<UpstreamSettings, UpstreamSettings> {
    private static final Logger log = LoggerFactory.getLogger(UpstreamSettingsConflictResolver.class);

    @Override
    public UpstreamSettings visit(SingleResult<UpstreamSettings> result) {
        return result.get();
    }

    @Override
    public UpstreamSettings visit(ConflictResults<UpstreamSettings> results) {
        UpstreamSettings chosen = results.getResults().keySet().stream().filter(upstreamSettings -> !upstreamSettings.isBlank()).min(new UpstreamSettingsComparator()).orElse(SimpleUpstreamSettings.blank());
        log.info("Conflict result received for upstream settings. Going to choose one from {}. Chose {}", results.getResults(), (Object)chosen);
        return chosen;
    }

    private static class UpstreamSettingsComparator
    implements Comparator<UpstreamSettings> {
        private UpstreamSettingsComparator() {
        }

        @Override
        public int compare(UpstreamSettings setting1, UpstreamSettings setting2) {
            if (setting1.getMode() == setting2.getMode()) {
                return ObjectUtils.compare((Comparable)setting2.getLastUpdatedTime().orElse(null), (Comparable)setting1.getLastUpdatedTime().orElse(null), (boolean)true);
            }
            return setting1.getMode() == MirroringMode.ALL_PROJECTS ? -1 : 1;
        }
    }
}

