/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamSettingsConflictResolver;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ConflictResults;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ErrorResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.ResultVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.SingleResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.topic.result.TimeoutResult;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettings;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamSettingsSetRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpstreamSettingsRepairer
implements ResultVisitor<UpstreamSettings, UpstreamSettings> {
    private static final Logger log = LoggerFactory.getLogger(UpstreamSettingsRepairer.class);
    private final InternalUpstreamService upstreamService;
    private final UpstreamSettingsConflictResolver upstreamSettingsConflictResolver;
    private final UpstreamSettingsService upstreamSettingsService;

    @Autowired
    public UpstreamSettingsRepairer(InternalUpstreamService upstreamService, UpstreamSettingsConflictResolver upstreamSettingsConflictResolver, UpstreamSettingsService upstreamSettingsService) {
        this.upstreamService = upstreamService;
        this.upstreamSettingsConflictResolver = upstreamSettingsConflictResolver;
        this.upstreamSettingsService = upstreamSettingsService;
    }

    @Override
    public UpstreamSettings visit(SingleResult<UpstreamSettings> result) {
        Object upstreamSettings = this.upstreamSettingsConflictResolver.visit((SingleResult)result);
        log.trace("All members of mirror farm have same settings {}", upstreamSettings);
        return upstreamSettings;
    }

    @Override
    public UpstreamSettings visit(ConflictResults<UpstreamSettings> results) {
        Object resolvedResult = this.upstreamSettingsConflictResolver.visit((ConflictResults)results);
        InternalUpstreamServer upstream = this.upstreamService.getUpstreamOrFail();
        UpstreamSettingsSetRequest request = new UpstreamSettingsSetRequest.Builder(upstream.getId()).mode(resolvedResult.getMode()).projectIds(resolvedResult.getMirroredProjectIds()).build();
        log.debug("Going to set settings on mirror farm : {}", (Object)request);
        return this.upstreamSettingsService.setSettings(request);
    }

    @Override
    public UpstreamSettings visit(ErrorResult<UpstreamSettings> results) {
        return (UpstreamSettings)this.upstreamSettingsConflictResolver.visit(results);
    }

    @Override
    public UpstreamSettings visit(TimeoutResult<UpstreamSettings> results) {
        return (UpstreamSettings)this.upstreamSettingsConflictResolver.visit(results);
    }
}

