/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.atst;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.RepositoryMappingDao;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepository;
import com.atlassian.bitbucket.mirroring.mirror.MirroredRepositoryService;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.troubleshooting.spi.SupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import com.atlassian.troubleshooting.spi.SupportDataDetail;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryMirrorSupportData
implements SupportDataAppender<Repository> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.of("UTC"));
    private static final String MIRROR_REPO = "bitbucket.atst.mirroring.mirror.upstreamserver.repository";
    private static final String MIRROR_LAST_UPDATED = "bitbucket.atst.mirroring.mirror.upstreamserver.repository.last.updated";
    private static final String MIRROR_REMOTE_ID = "bitbucket.atst.mirroring.mirror.upstreamserver.repository.id";
    private static final String MIRROR_STATUS = "bitbucket.atst.mirroring.mirror.upstreamserver.repository.status";
    private static final Logger log = LoggerFactory.getLogger(RepositoryMirrorSupportData.class);
    private final RepositoryMappingDao mappingDao;
    private final MirroredRepositoryService mirroredRepositoryService;
    private final InternalUpstreamService upstreamService;

    public RepositoryMirrorSupportData(MirroredRepositoryService mirroredRepositoryService, InternalUpstreamService upstreamService, RepositoryMappingDao mappingDao) {
        this.mirroredRepositoryService = mirroredRepositoryService;
        this.upstreamService = upstreamService;
        this.mappingDao = mappingDao;
    }

    public void addSupportData(SupportDataBuilder supportDataBuilder, Repository context) {
        if (this.upstreamService.isMirror() && supportDataBuilder.getBuilderContext().getRequestDetail() == SupportDataDetail.FULL) {
            SupportDataBuilder categoryBuilder = supportDataBuilder.addCategory(MIRROR_REPO);
            InternalUpstreamServer upstreamServer = this.upstreamService.get();
            if (upstreamServer != null) {
                AoRepositoryMapping mapping = this.mappingDao.getByLocalId(context.getId());
                if (mapping != null) {
                    try {
                        MirroredRepository repository = this.mirroredRepositoryService.getRepository(mapping.getExternalId());
                        categoryBuilder.addValue(MIRROR_STATUS, repository.getStatus().toString()).addValue(MIRROR_REMOTE_ID, repository.getRepositoryId()).addValue(MIRROR_LAST_UPDATED, (String)repository.getLastUpdated().map(Date::toInstant).map(FORMATTER::format).orElse(null));
                    }
                    catch (NoSuchRepositoryException e) {
                        log.warn("No mirrored repository found for upstream ID {} and repository with ID ({})", new Object[]{upstreamServer.getId(), mapping.getExternalId(), e});
                    }
                } else {
                    log.warn("{}: Repository mapping not found for repository", (Object)context);
                }
            }
        }
    }
}

