/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.atst;

import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.troubleshooting.spi.RootLevelSupportDataAppender;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import java.time.Instant;
import java.util.Date;
import java.util.Optional;

public class UpstreamServersSupportData
extends RootLevelSupportDataAppender {
    private static final String UPSTREAM = "bitbucket.atst.mirroring.mirror.upstreamserver";
    private static final String UPSTREAMS = "bitbucket.atst.mirroring.mirror.upstreamservers";
    private static final String UPSTREAM_BASE_URL = "bitbucket.atst.mirroring.mirror.upstreamserver.baseurl";
    private static final String UPSTREAM_ID = "bitbucket.atst.mirroring.mirror.upstreamserver.id";
    private static final String UPSTREAM_ISSUER_ID = "bitbucket.atst.mirroring.mirror.upstreamserver.issuer.id";
    private static final String UPSTREAM_LAST_SETTING_CHANGE = "bitbucket.atst.mirroring.mirror.upstreamserver.last.setting.change";
    private static final String UPSTREAM_LAST_SYNC = "bitbucket.atst.mirroring.mirror.upstreamserver.last.sync";
    private static final String UPSTREAM_STATE = "bitbucket.atst.mirroring.mirror.upstreamserver.state";
    private final InternalUpstreamService upstreamService;

    public UpstreamServersSupportData(InternalUpstreamService upstreamService) {
        this.upstreamService = upstreamService;
    }

    protected void addSupportData(SupportDataBuilder supportDataBuilder) {
        if (this.upstreamService.isMirror()) {
            SupportDataBuilder categoryBuilder = supportDataBuilder.addCategory(UPSTREAMS);
            InternalUpstreamServer upstreamServer = this.upstreamService.get();
            if (upstreamServer != null) {
                categoryBuilder.addCategory(UPSTREAM).addValue(UPSTREAM_BASE_URL, upstreamServer.getBaseUrl()).addValue(UPSTREAM_ID, upstreamServer.getId()).addValue(UPSTREAM_ISSUER_ID, (String)upstreamServer.getIssuerId().orElse(null)).addValue(UPSTREAM_LAST_SETTING_CHANGE, (String)Optional.ofNullable(upstreamServer.getLastSettingsChangeDate()).map(Date::toInstant).map(Instant::toString).orElse(null)).addValue(UPSTREAM_LAST_SYNC, (String)Optional.ofNullable(upstreamServer.getLastFullSyncDate()).map(Date::toInstant).map(Instant::toString).orElse(null)).addValue(UPSTREAM_STATE, upstreamServer.getState().toString()).addContext((Object)upstreamServer);
            }
        }
    }
}

