/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationSuccessHandler;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.SimpleJwtUser;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.request.RequestInfoProvider;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMirrorAuthenticationContext
implements MirrorAuthenticationContext,
HttpAuthenticationSuccessHandler {
    private static final Logger log = LoggerFactory.getLogger(AbstractMirrorAuthenticationContext.class);
    private final AuthenticationContext authenticationContext;
    private final ObjectMapper mapper;
    private final RequestManager requestManager;

    @Autowired
    public AbstractMirrorAuthenticationContext(AuthenticationContext authenticationContext, RequestManager requestManager) {
        this.authenticationContext = authenticationContext;
        this.requestManager = requestManager;
        this.mapper = new ObjectMapper();
    }

    @Override
    @Nonnull
    public Optional<ServiceUser> getCurrentUpstreamUser() {
        ApplicationUser user = this.authenticationContext.getCurrentUser();
        if (MirroringUserUtils.isUpstreamUser(user)) {
            return Optional.of((ServiceUser)user);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ApplicationUser> getImpersonatedUser() {
        return this.getHttpRequest().flatMap(req -> {
            Object attr = req.getAttribute("bitbucket.jwt.subject.user");
            if (attr instanceof Optional) {
                return (Optional)attr;
            }
            Optional<ApplicationUser> resolved = this.doGetImpersonatedUser((HttpServletRequest)req);
            req.setAttribute("bitbucket.jwt.subject.user", resolved);
            return resolved.filter(this::isImpersonatedUserReturned);
        });
    }

    @Override
    @Nonnull
    public Optional<Permission> getImpersonatedUserHighestPermission() {
        return this.getImpersonatedUser().filter(SimpleJwtUser.class::isInstance).map(SimpleJwtUser.class::cast).map(SimpleJwtUser::getHighestPermission);
    }

    public boolean onAuthenticationSuccess(@Nonnull HttpAuthenticationSuccessContext context) {
        HttpSession session;
        HttpServletRequest request = context.getRequest();
        Object jwtPayloadAtt = request.getAttribute("jwt.payload");
        if (jwtPayloadAtt != null && (session = request.getSession(false)) != null) {
            session.setAttribute("bitbucket.jwt.payload", jwtPayloadAtt);
        }
        return false;
    }

    abstract Optional<ApplicationUser> doGetImpersonatedUser(HttpServletRequest var1);

    abstract boolean isImpersonatedUserReturned(ApplicationUser var1);

    private Optional<HttpServletRequest> getHttpRequest() {
        return Optional.ofNullable(this.requestManager.getRequestContext()).map(RequestInfoProvider::getRawRequest).filter(rawRequest -> HttpServletRequest.class.isAssignableFrom(rawRequest.getClass())).map(HttpServletRequest.class::cast);
    }
}

