/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.AbstractMirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SimpleUser;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaims;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaimsUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.SimpleJwtUser;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="defaultMirrorAuthenticationContext")
public class DefaultMirrorAuthenticationContext
extends AbstractMirrorAuthenticationContext {
    public DefaultMirrorAuthenticationContext(AuthenticationContext authenticationContext, RequestManager requestManager) {
        super(authenticationContext, requestManager);
    }

    @Override
    public Optional<ApplicationUser> doGetImpersonatedUser(HttpServletRequest req) {
        Optional<ApplicationUser> user = this.getApplicationUserFromJwt(req);
        if (!user.isPresent()) {
            user = this.getApplicationUserFromParams(req);
        }
        return user;
    }

    private Optional<ApplicationUser> getApplicationUserFromJwt(HttpServletRequest request) {
        return JwtClaimsUtils.getJwtClaims(request).flatMap(JwtClaims::getContextUser).map(SimpleJwtUser::new);
    }

    private Optional<ApplicationUser> getApplicationUserFromParams(HttpServletRequest request) {
        return Optional.ofNullable(StringUtils.stripToNull((String)request.getParameter("upstream-username"))).filter(value -> !value.equals("{user.username}")).map(SimpleUser::new);
    }

    @Override
    boolean isImpersonatedUserReturned(ApplicationUser ignored) {
        return this.getCurrentUpstreamUser().isPresent();
    }
}

