/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorKeyUploadFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentials;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.SyncCredentialsManager;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.UpstreamServerDao;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.MirrorKeyStorageException;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SshKeyStore;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PublicKeyEncodingHelper;
import com.atlassian.bitbucket.mirroring.mirror.MirrorRemovedUpstreamEvent;
import com.atlassian.bitbucket.mirroring.mirror.NoSuchUpstreamException;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.scm.git.auth.GitAuthHelper;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderSupport;
import com.atlassian.bitbucket.scm.mirror.MirrorSyncCommandParameters;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import jakarta.annotation.Nonnull;
import java.net.URI;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DefaultSyncCredentialsManager
implements SyncCredentialsManager,
InitializingBean,
DisposableBean {
    private static final int NO_VERSION = -1;
    private static final String SECRET_KEY = "SSH_KEYS";
    private static final Logger log = LoggerFactory.getLogger(DefaultSyncCredentialsManager.class);
    private final GitAuthHelper authHelper;
    private final ExecutorService executorService;
    private final I18nService i18nService;
    private final ApplicationPropertiesService propertiesService;
    private final PublicKeyEncodingHelper publicKeyEncodingHelper;
    private final DmzSecretService secretService;
    private final ConcurrentMap<String, Pair<Integer, Promise<DefaultSyncCredentials>>> serverCredentials;
    private final SshKeyStore sshKeyStore;
    private final TransactionTemplate transactionTemplate;
    private final InternalUpstreamClientFactory upstreamClientFactory;
    private final UpstreamServerDao upstreamServerDao;
    private String secretUpdateSubscriptionId;

    @Autowired
    public DefaultSyncCredentialsManager(GitAuthHelper authHelper, @Qualifier(value="scheduledExecutorService") ExecutorService executorService, I18nService i18nService, ApplicationPropertiesService propertiesService, PublicKeyEncodingHelper publicKeyEncodingHelper, DmzSecretService secretService, SshKeyStore sshKeyStore, TransactionTemplate transactionTemplate, InternalUpstreamClientFactory upstreamClientFactory, UpstreamServerDao upstreamServerDao) {
        this.authHelper = authHelper;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.propertiesService = propertiesService;
        this.publicKeyEncodingHelper = publicKeyEncodingHelper;
        this.secretService = secretService;
        this.sshKeyStore = sshKeyStore;
        this.transactionTemplate = transactionTemplate;
        this.upstreamClientFactory = upstreamClientFactory;
        this.upstreamServerDao = upstreamServerDao;
        this.serverCredentials = Maps.newConcurrentMap();
    }

    public void afterPropertiesSet() {
        this.secretUpdateSubscriptionId = this.secretService.registerChangeListener(SECRET_KEY, this::onFarmKeysUpdated);
    }

    @Override
    public void deleteCredentials(@Nonnull String upstreamId) {
        Objects.requireNonNull(upstreamId, "upstreamId");
        this.executorService.execute(() -> this.secretService.compute(SECRET_KEY, keys -> {
            this.serverCredentials.computeIfPresent(upstreamId, (ignoredKey, ignoredValue) -> {
                log.debug("[{}]: Deleting SSH key as the mirror is removed from upstream server", (Object)upstreamId);
                this.sshKeyStore.delete(upstreamId);
                return null;
            });
            return ImmutableMap.of();
        }));
    }

    public void destroy() {
        this.secretService.unregisterChangeListener(this.secretUpdateSubscriptionId);
    }

    @Override
    @Nonnull
    public Promise<SyncCredentials> getCredentials(@Nonnull String upstreamId) {
        return this.computeCredentials(-1, this.getUpstreamOrFail(upstreamId));
    }

    @EventListener
    public void onMirrorBootstrapped(MirrorBootstrappedEvent ignored) {
        this.synchronizeLocalCredentialsWithFarm();
    }

    @EventListener
    public void onMirrorUpstreamRemoved(MirrorRemovedUpstreamEvent event) {
        this.deleteCredentials(event.getUpstream().getId());
    }

    @Override
    @Nonnull
    public Promise<SyncCredentials> refresh(@Nonnull SyncCredentials credentials) {
        return this.computeCredentials(((DefaultSyncCredentials)credentials).getVersion(), ((DefaultSyncCredentials)credentials).getUpstream());
    }

    private static Throwable detailsIfDebug(Throwable t) {
        return log.isDebugEnabled() ? t : null;
    }

    @Nonnull
    private <C extends SyncCredentials> Promise<C> computeCredentials(int callerCredentialsVersion, @Nonnull UpstreamServer upstream) {
        return this.computeCredentialsFor(this.serverCredentials, callerCredentialsVersion, this::getServerCredentials, upstream);
    }

    private <C extends SyncCredentials> Promise<C> computeCredentialsFor(@Nonnull ConcurrentMap<String, Pair<Integer, Promise<C>>> allCredentials, int callerCredentialsVersion, @Nonnull CredentialsProvider<C> credentialsProvider, @Nonnull UpstreamServer upstream) {
        return (Promise)allCredentials.compute(upstream.getId(), (id, existing) -> {
            boolean requiresNewCredentials;
            boolean firstComputationRequest = existing == null;
            boolean refreshRequested = callerCredentialsVersion != -1;
            boolean inProgress = !firstComputationRequest && !((Promise)existing.right()).isDone();
            boolean inError = !firstComputationRequest && !inProgress && this.isError((Promise)existing.right());
            boolean callerCredentialsStale = !firstComputationRequest && (Integer)existing.left() > callerCredentialsVersion;
            Preconditions.checkState((!firstComputationRequest || callerCredentialsVersion == -1 ? 1 : 0) != 0, (Object)"Unexpected state: computation does not exist in the map but a refresh has been requested");
            if (inProgress || callerCredentialsStale && !inError) {
                if (log.isTraceEnabled()) {
                    String reason = inProgress ? "it is still ongoing" : "the caller has stale credentials";
                    log.trace("Using existing credentials computation for {} because: {}", MirrorDescriptionUtils.describe(upstream), (Object)reason);
                }
                return existing;
            }
            boolean bl = requiresNewCredentials = refreshRequested || inError;
            if (log.isTraceEnabled()) {
                String reason = firstComputationRequest ? "this is the first computation for that upstream since the application started" : (refreshRequested ? "the caller has asked for a refresh of the credentials" : "the last computation resulted in an error");
                log.trace("Computing credentials for {} because: {}.", MirrorDescriptionUtils.describe(upstream), (Object)reason);
            }
            return Pair.pair((Object)(callerCredentialsVersion + 1), credentialsProvider.get(callerCredentialsVersion + 1, requiresNewCredentials, upstream));
        }).right();
    }

    private void deleteUpstreamSshKeys(UpstreamServer upstream) {
        try {
            this.upstreamClientFactory.create(upstream).deleteSshKeys();
        }
        catch (RuntimeException e) {
            log.info("Failed to delete SSH key with upstream {}: '{}'", new Object[]{upstream.getBaseUrl(), e.getMessage(), DefaultSyncCredentialsManager.detailsIfDebug(e)});
        }
    }

    private String getLabel() {
        URI baseUrl = this.propertiesService.getBaseUrl();
        if (baseUrl != null) {
            return "mirror " + baseUrl.toASCIIString();
        }
        return "mirror " + this.propertiesService.getDisplayName() + "(" + this.propertiesService.getServerId() + ")";
    }

    @Nonnull
    private Promise<DefaultSyncCredentials> getServerCredentials(int nextVersion, boolean requiresNew, UpstreamServer upstream) {
        Optional<Path> keyFile;
        if (!requiresNew && (keyFile = this.sshKeyStore.getPrivateKey(upstream.getId())).isPresent()) {
            log.trace("{}: SSH key found at {}", MirrorDescriptionUtils.describe(upstream), (Object)keyFile.get().toAbsolutePath());
            return Promises.promise((Object)new DefaultSyncCredentials(keyFile.get(), upstream, nextVersion));
        }
        Promises.SettablePromise promise = Promises.settablePromise();
        this.executorService.submit(() -> {
            log.info("{}: Generating and configuring an SSH key", MirrorDescriptionUtils.describe(upstream));
            MutableObject privateKeyPath = new MutableObject();
            try {
                this.secretService.compute(SECRET_KEY, keys -> {
                    keys = keys == null ? new HashMap<String, PrivateKey>() : new HashMap(keys);
                    if (requiresNew) {
                        log.debug("{}: Deleting all existing SSH keys", MirrorDescriptionUtils.describe(upstream));
                        this.deleteUpstreamSshKeys(upstream);
                        this.sshKeyStore.delete(upstream.getId());
                    }
                    Pair<Path, KeyPair> pathAndKeyPair = this.sshKeyStore.generateKeyPair(upstream.getId());
                    keys.put(upstream.getId(), ((KeyPair)pathAndKeyPair.right()).getPrivate());
                    this.uploadSshKey(upstream, this.publicKeyEncodingHelper.encodeAsOpenSsh(((KeyPair)pathAndKeyPair.right()).getPublic(), this.getLabel()));
                    privateKeyPath.setValue((Object)((Path)pathAndKeyPair.left()));
                    return ImmutableMap.copyOf(keys);
                });
                promise.set((Object)new DefaultSyncCredentials((Path)privateKeyPath.getValue(), upstream, nextVersion));
            }
            catch (Exception e) {
                promise.exception((Throwable)e);
            }
        });
        return promise;
    }

    private void onFarmKeysUpdated(Map<String, PrivateKey> keys) {
        keys.forEach((upstreamId, privateKey) -> {
            log.debug("[{}] Received SSH key update", upstreamId);
            this.serverCredentials.compute((String)upstreamId, (id, ignored) -> {
                this.sshKeyStore.update((String)id, (PrivateKey)privateKey);
                return null;
            });
        });
    }

    private void synchronizeLocalCredentialsWithFarm() {
        this.secretService.compute(SECRET_KEY, farmKeys -> {
            AoUpstreamServer upstream = this.upstreamServerDao.getUpstream();
            farmKeys = farmKeys == null ? new HashMap<String, PrivateKey>() : new HashMap(farmKeys);
            HashSet upstreamIds = new HashSet(farmKeys.keySet());
            if (upstream != null) {
                upstreamIds.add(upstream.getId());
            }
            for (String maybeUpstreamId : upstreamIds) {
                farmKeys.compute(maybeUpstreamId, (upstreamId, farmKey) -> {
                    PrivateKey localKey = this.sshKeyStore.getKeyPair((String)upstreamId).map(KeyPair::getPrivate).orElse(null);
                    if (localKey == null) {
                        if (farmKey != null) {
                            log.debug("[{}] No local SSH key present, using farm provided key.", upstreamId);
                            this.serverCredentials.compute((String)upstreamId, (id, ignored) -> {
                                this.sshKeyStore.update((String)id, (PrivateKey)farmKey);
                                return null;
                            });
                            return farmKey;
                        }
                        log.trace("[{}] No SSH keys present, nothing to do.", upstreamId);
                        return null;
                    }
                    if (farmKey == null) {
                        log.debug("[{}] Farm is missing SSH key, sharing local key with farm.", upstreamId);
                        return localKey;
                    }
                    if (!localKey.equals(farmKey)) {
                        log.warn("[{}] Local SSH key does not match farm's key. Overriding local key with farm key.", upstreamId);
                        this.serverCredentials.compute((String)upstreamId, (id, ignored) -> {
                            this.sshKeyStore.update((String)upstreamId, (PrivateKey)farmKey);
                            return null;
                        });
                        return farmKey;
                    }
                    log.debug("[{}] Farm SSH key and local SSH key matches, nothing to do.", upstreamId);
                    return farmKey;
                });
            }
            return ImmutableMap.copyOf(farmKeys);
        });
    }

    private void uploadSshKey(UpstreamServer upstream, String publicKey) {
        try {
            this.upstreamClientFactory.create(upstream).uploadSshKey(publicKey);
            log.info("The SSH key for this mirror was uploaded to {}", MirrorDescriptionUtils.describe(upstream));
        }
        catch (Exception e) {
            if (e instanceof MirrorKeyUploadFailedException) {
                log.error("Uploading the SSH key for {} failed. Upstream fetches will not proceed until this is corrected.", MirrorDescriptionUtils.describe(upstream), (Object)DefaultSyncCredentialsManager.detailsIfDebug(e));
            } else if (e instanceof MirrorKeyStorageException) {
                log.error("Storing the SSH key for {} failed. Upstream fetches will not proceed.", MirrorDescriptionUtils.describe(upstream), (Object)DefaultSyncCredentialsManager.detailsIfDebug(e));
            } else {
                log.error("An unexpected error was encountered while uploading and storing the SSH key for {}. Synchronization will not proceed.", MirrorDescriptionUtils.describe(upstream), (Object)DefaultSyncCredentialsManager.detailsIfDebug(e));
            }
            throw e;
        }
    }

    private AoUpstreamServer getUpstreamOrFail(@Nonnull String upstreamId) {
        return (AoUpstreamServer)this.transactionTemplate.execute(() -> {
            AoUpstreamServer upstream = this.upstreamServerDao.getById(upstreamId);
            if (upstream == null) {
                throw new NoSuchUpstreamException(this.i18nService.createKeyedMessage("bitbucket.mirroring.no.such.upstream.server", new Object[]{upstreamId}));
            }
            return upstream;
        });
    }

    private <C> boolean isError(Promise<C> existing) {
        if (existing.isDone()) {
            try {
                existing.claim();
            }
            catch (Throwable e) {
                return true;
            }
        }
        return false;
    }

    private class DefaultSyncCredentials
    implements SyncCredentials {
        protected final UpstreamServer upstream;
        protected final int version;
        private final Path keyFile;

        private DefaultSyncCredentials(@Nonnull Path keyFile, UpstreamServer upstream, int version) {
            this.version = version;
            this.upstream = upstream;
            this.keyFile = keyFile;
        }

        @Override
        @Nonnull
        public MirrorSyncCommandParameters.Builder configure(@Nonnull MirrorSyncCommandParameters.Builder builder) {
            return builder.privateKey(this.keyFile);
        }

        @Override
        @Nonnull
        public <T extends GitCommandBuilderSupport<T>> GitCommandBuilderSupport<T> configure(@Nonnull GitCommandBuilderSupport<T> builder) {
            return DefaultSyncCredentialsManager.this.authHelper.configure(builder, null, null, this.keyFile);
        }

        @Override
        @Nonnull
        public Path getKeyFile() {
            return this.keyFile;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keyFile", (Object)this.keyFile).add("upstream", (Object)this.upstream).add("version", this.version).toString();
        }

        public UpstreamServer getUpstream() {
            return this.upstream;
        }

        public int getVersion() {
            return this.version;
        }
    }

    @FunctionalInterface
    static interface CredentialsProvider<C extends SyncCredentials> {
        @Nonnull
        public Promise<C> get(int var1, boolean var2, @Nonnull UpstreamServer var3);
    }
}

