/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.LocalisingPermissionVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.ResourceIdCollectingPermissionVisitor;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticatorFactory;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.internal.mirroring.user.SimpleApplicationUserWithPermissions;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DelegatedAuthenticationHandlerBase {
    private static final Pair<Map<String, Integer>, Map<String, Integer>> EMPTY_PAIR = Pair.pair(Collections.emptyMap(), Collections.emptyMap());
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final UpstreamAuthenticatorFactory authenticatorFactory;
    protected final I18nService i18nService;
    protected final TransactionTemplate transactionTemplate;
    protected final InternalUpstreamService upstreamService;
    private final EscalatedSecurityContext withRead;

    public DelegatedAuthenticationHandlerBase(UpstreamAuthenticatorFactory authenticatorFactory, I18nService i18nService, SecurityService securityService, TransactionTemplate transactionTemplate, InternalUpstreamService upstreamService) {
        this.authenticatorFactory = authenticatorFactory;
        this.i18nService = i18nService;
        this.transactionTemplate = transactionTemplate;
        this.upstreamService = upstreamService;
        this.withRead = securityService.withPermission(Permission.PROJECT_READ, "for mapping remote projects and repositories to local versions");
    }

    protected ApplicationUserWithPermissions localiseResourcePermissions(ApplicationUserWithPermissions user) {
        Objects.requireNonNull(user, "user");
        return (ApplicationUserWithPermissions)this.withRead.call(() -> {
            List effectivePermissions = user.getEffectivePermissions();
            if (!Iterables.isEmpty(effectivePermissions)) {
                ResourceIdCollectingPermissionVisitor resourceIdCollectingVisitor = new ResourceIdCollectingPermissionVisitor();
                for (EffectivePermission permission : effectivePermissions) {
                    permission.accept((EffectivePermissionVisitor)resourceIdCollectingVisitor);
                }
                Pair<Map<String, Integer>, Map<String, Integer>> resourceIdLookups = this.lookupLocalResourceIds(resourceIdCollectingVisitor.getProjectIds(), resourceIdCollectingVisitor.getRepositoryIds());
                effectivePermissions = Chainable.chain(effectivePermissions).transform(this.localiseResourcePermissions((Map)resourceIdLookups.left(), (Map)resourceIdLookups.right())).filter(Objects::nonNull).toList();
            }
            return new SimpleApplicationUserWithPermissions(user, effectivePermissions);
        });
    }

    private Function<EffectivePermission, EffectivePermission> localiseResourcePermissions(Map<String, Integer> projectIdLookup, Map<String, Integer> repositoryIdLookup) {
        LocalisingPermissionVisitor localisingVisitor = new LocalisingPermissionVisitor(projectIdLookup, repositoryIdLookup);
        return effectivePermission -> (EffectivePermission)effectivePermission.accept((EffectivePermissionVisitor)localisingVisitor);
    }

    private Pair<Map<String, Integer>, Map<String, Integer>> lookupLocalResourceIds(Set<String> remoteProjectIds, Set<String> remoteRepositoryIds) {
        InternalUpstreamServer upstreamServer = this.upstreamService.get();
        if (upstreamServer == null) {
            this.log.warn("No upstream server found. Resource mapping lookup failed.");
            return EMPTY_PAIR;
        }
        return (Pair)this.transactionTemplate.execute(() -> Pair.pair(this.upstreamService.mapToLocalProjects(upstreamServer.getId(), remoteProjectIds), this.upstreamService.mapToLocalRepositories(upstreamServer.getId(), remoteRepositoryIds)));
    }
}

