/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.dmz.permission.EffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.EffectivePermissionVisitor;
import com.atlassian.bitbucket.dmz.permission.EffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.EffectiveRepositoryPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveProjectPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveRepositoryPermission;
import jakarta.annotation.Nonnull;
import java.util.Map;

public class LocalisingPermissionVisitor
implements EffectivePermissionVisitor<EffectivePermission> {
    private final Map<String, Integer> localProjectsIds;
    private final Map<String, Integer> localRepositoryIds;

    public LocalisingPermissionVisitor(Map<String, Integer> localProjectsIds, Map<String, Integer> localRepositoryIds) {
        this.localProjectsIds = localProjectsIds;
        this.localRepositoryIds = localRepositoryIds;
    }

    public EffectivePermission visit(@Nonnull EffectiveGlobalPermission permission) {
        return permission;
    }

    public EffectivePermission visit(@Nonnull EffectiveRepositoryPermission permission) {
        Integer localRepositoryId = this.localRepositoryIds.get(String.valueOf(permission.getRepositoryId()));
        if (localRepositoryId == null) {
            return null;
        }
        return new SimpleEffectiveRepositoryPermission(localRepositoryId.intValue(), permission.getPermission());
    }

    public EffectivePermission visit(@Nonnull EffectiveProjectPermission permission) {
        Integer localProjectId = this.localProjectsIds.get(String.valueOf(permission.getProjectId()));
        if (localProjectId == null) {
            return null;
        }
        return new SimpleEffectiveProjectPermission(localProjectId.intValue(), permission.getPermission());
    }
}

