/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.permission.EffectivePermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveGlobalPermission;
import com.atlassian.bitbucket.dmz.permission.SimpleEffectiveRepositoryPermission;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.AbstractMirrorAuthenticationContext;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaims;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaimsUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.SimpleJwtUser;
import com.atlassian.bitbucket.internal.mirroring.user.SimpleApplicationUserWithPermissions;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryMovedException;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="mirrorLfsAuthenticationContext")
public class MirrorLfsAuthenticationContext
extends AbstractMirrorAuthenticationContext {
    private final RepositorySupplier repositorySupplier;
    private final EscalatedSecurityContext withRepoRead;

    public MirrorLfsAuthenticationContext(AuthenticationContext authenticationContext, RequestManager requestManager, @Qualifier(value="repositorySupplier") RepositorySupplier repositorySupplier, SecurityService securityService) {
        super(authenticationContext, requestManager);
        this.repositorySupplier = repositorySupplier;
        this.withRepoRead = securityService.withPermission(Permission.REPO_READ, "Validate Git LFS JWT");
    }

    @Override
    public Optional<ApplicationUser> doGetImpersonatedUser(HttpServletRequest req) {
        Optional<JwtClaims> jwtClaims = JwtClaimsUtils.getJwtClaims(req);
        return jwtClaims.flatMap(JwtClaims::getContextUser).map(SimpleJwtUser::new).flatMap(user -> this.userWithSingleRepoAccess(jwtClaims, (ApplicationUser)user));
    }

    @Override
    boolean isImpersonatedUserReturned(ApplicationUser ignored) {
        return true;
    }

    @Nullable
    private Repository getRepositoryFromClaim(String claimName) {
        Repository repository;
        String repoSlug;
        String projectKey;
        String[] split = claimName.split("/");
        if (split.length == 3) {
            projectKey = split[1];
            repoSlug = split[2];
        } else if (split.length == 2) {
            projectKey = split[0];
            repoSlug = split[1];
        } else {
            throw new IllegalArgumentException("Invalid repository claim: " + claimName);
        }
        try {
            repository = (Repository)this.withRepoRead.call(() -> this.repositorySupplier.getBySlug(projectKey, repoSlug));
        }
        catch (RepositoryMovedException e) {
            repository = e.getRepository();
        }
        return repository;
    }

    private Optional<ApplicationUser> userWithSingleRepoAccess(Optional<JwtClaims> jwtClaims, ApplicationUser user) {
        return jwtClaims.get().getRepository().map(this::getRepositoryFromClaim).map(repository -> new SimpleApplicationUserWithPermissions(user, (Iterable<EffectivePermission>)ImmutableList.of((Object)new SimpleEffectiveGlobalPermission(Permission.LICENSED_USER), (Object)new SimpleEffectiveRepositoryPermission(repository.getId(), Permission.REPO_READ))));
    }
}

