/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorAuthenticationContext;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;

public class MirrorLfsJwtAuthenticationHandler
implements HttpAuthenticationHandler {
    public static final Pattern LFS_BATCH_URL_PATTERN = Pattern.compile("(?:/?[^/]*?)/?([^/]+)/([^/']+?)(?:\\.git)?/info/lfs/objects/batch");
    private final MirrorAuthenticationContext mirrorAuthenticationContext;

    public MirrorLfsJwtAuthenticationHandler(@Qualifier(value="mirrorLfsAuthenticationContext") MirrorAuthenticationContext mirrorAuthenticationContext) {
        this.mirrorAuthenticationContext = mirrorAuthenticationContext;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
        HttpServletRequest request = authenticationContext.getRequest();
        if (this.shouldAttemptJwtAuthentication(request)) {
            return this.mirrorAuthenticationContext.getImpersonatedUser().map(impersonatingUser -> new AuthenticationResult.Builder(impersonatingUser).build()).orElse(null);
        }
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private boolean isLfsSshBatchRequest(HttpServletRequest request) {
        Objects.requireNonNull(request, "request");
        String authorization = request.getHeader("Authorization");
        if (authorization != null && authorization.contains("JWT")) {
            String pathInfo = request.getPathInfo();
            if ("POST".equals(request.getMethod()) && pathInfo != null) {
                Matcher matcher = LFS_BATCH_URL_PATTERN.matcher(pathInfo);
                return matcher.matches();
            }
        }
        return false;
    }

    private boolean isLfsStorageRequest(HttpServletRequest request) {
        return StringUtils.startsWith((CharSequence)request.getServletPath(), (CharSequence)"/rest/git-lfs/storage");
    }

    private boolean shouldAttemptJwtAuthentication(HttpServletRequest request) {
        return this.isLfsStorageRequest(request) || this.isLfsSshBatchRequest(request);
    }
}

