/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestAuthenticator
implements UpstreamAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticator.class);
    private final I18nService i18nService;
    private final InternalUpstreamClientFactory upstreamClientFactory;
    private final UpstreamServer upstream;

    public RestAuthenticator(@Nonnull I18nService i18nService, @Nonnull UpstreamServer upstream, @Nonnull InternalUpstreamClientFactory upstreamClientFactory) {
        this.i18nService = i18nService;
        this.upstreamClientFactory = upstreamClientFactory;
        this.upstream = upstream;
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String username, @Nonnull String password, Integer repoId) {
        return this.handle(() -> this.upstreamClientFactory.create(this.upstream).authenticateForUser(username, password, repoId));
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String token, @Nullable Integer repoId) {
        return this.handle(() -> this.upstreamClientFactory.create(this.upstream).authenticateForUser(token, repoId));
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String sshUsername, @Nonnull PublicKey publicKey) {
        return this.handle(() -> this.upstreamClientFactory.create(this.upstream).authenticateForUser(sshUsername, publicKey));
    }

    @Override
    public boolean isAvailable(@Nonnull UpstreamServer upstream) {
        if (upstream.getState() != IntegrationState.INSTALLED) {
            log.info("Not delegating HTTP authentication because this mirror's installation state with respect to the upstream server is currently {}", (Object)upstream.getState());
            return false;
        }
        return true;
    }

    private <X> X handle(@Nonnull Supplier<X> supplier) {
        try {
            return Objects.requireNonNull(supplier).get();
        }
        catch (AuthorisationException | AuthenticationException | UpstreamRequestFailedException e2) {
            throw e2;
        }
        catch (Exception e) {
            try {
                throw Throwables.getRootCause((Throwable)e);
            }
            catch (AuthorisationException | AuthenticationException | UpstreamRequestFailedException e2) {
                throw e2;
            }
            catch (ConnectException e2) {
                log.warn("A request to the upstream server failed because it is not reachable", (Throwable)e2);
                throw this.throwRequestFailedException(e2);
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                log.warn("A request to the upstream server was interrupted", (Throwable)e2);
                throw this.throwRequestFailedException(e2);
            }
            catch (SocketTimeoutException | TimeoutException e2) {
                log.warn("A request to the upstream server timed out", (Throwable)e2);
                throw this.throwRequestFailedException(e2);
            }
            catch (Exception e2) {
                log.warn("An request to the upstream server encountered an unexpected error", (Throwable)e2);
                throw this.throwRequestFailedException(e2);
            }
            catch (Throwable t) {
                log.warn("An request to the upstream server encountered an unexpected throwable", t);
                throw this.throwRequestFailedException(t);
            }
        }
    }

    private UpstreamRequestFailedException throwRequestFailedException(Throwable cause) {
        throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.unexpected", new Object[0]), cause);
    }
}

