/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache;

import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHash;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class AuthCacheKey {
    private final CredentialsHash credentialsHash;
    private final int localRepoId;

    private AuthCacheKey(@Nonnull Builder builder) {
        this.credentialsHash = Objects.requireNonNull(builder.credentialsHash, "credentialsHash");
        this.localRepoId = builder.localRepoId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthCacheKey that = (AuthCacheKey)o;
        return this.localRepoId == that.localRepoId && Objects.equals(this.credentialsHash, that.credentialsHash);
    }

    public int hashCode() {
        return Objects.hash(this.credentialsHash, this.localRepoId);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"");
        if (this.localRepoId != -1) {
            helper = helper.add("repo", this.localRepoId);
        }
        return helper.add("credentials", (Object)this.credentialsHash).toString();
    }

    static class Builder {
        private CredentialsHash credentialsHash;
        private int localRepoId = -1;

        Builder() {
        }

        @Nonnull
        AuthCacheKey build() {
            return new AuthCacheKey(this);
        }

        @Nonnull
        Builder withCredentialsHash(@Nonnull CredentialsHash value) {
            this.credentialsHash = Objects.requireNonNull(value, "credentialsHash");
            return this;
        }

        @Nonnull
        Builder withRepository(Integer localRepoId) {
            if (localRepoId != null) {
                this.localRepoId = localRepoId;
            }
            return this;
        }

        @Nonnull
        Builder withRepository(int localRepoId) {
            this.localRepoId = localRepoId;
            return this;
        }
    }
}

