/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.AuthCacheKey;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.AuthResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHashingService;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.Supplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseCachingAuthenticator<T>
implements UpstreamAuthenticator {
    private static final Logger log = LoggerFactory.getLogger(BaseCachingAuthenticator.class);
    protected final Cache<AuthCacheKey, AuthResult<T>> fallbackAuthCache;
    protected final Cache<AuthCacheKey, AuthResult<T>> recentAuthCache;
    protected final CredentialsHashingService hashingService;
    protected final UpstreamServer upstream;
    private final Duration unknownStateLeeway;
    private final Clock clock;

    BaseCachingAuthenticator(@Nonnull UpstreamServer upstream, @Nonnull CacheFactory cacheFactory, @Nonnull Clock clock, @Nonnull MirroringConfig config, @Nonnull CredentialsHashingService hashingService) {
        Objects.requireNonNull(cacheFactory, "cacheFactory");
        Objects.requireNonNull(config, "config");
        Preconditions.checkArgument((boolean)config.isAuthCachingEnabled(), (Object)"Auth caching must be disabled enabled for this authenticator");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.hashingService = Objects.requireNonNull(hashingService, "hashingService");
        this.upstream = Objects.requireNonNull(upstream, "upstream");
        this.fallbackAuthCache = this.createFallbackAuthCache(config, cacheFactory, upstream.getId());
        this.recentAuthCache = this.createRecentAuthCache(config, cacheFactory, upstream.getId());
        this.unknownStateLeeway = Duration.of(config.getFallbackAuthCacheTtl(), ChronoUnit.SECONDS);
    }

    @Override
    public boolean isAvailable(@Nonnull UpstreamServer upstream) {
        if (upstream.getState() == IntegrationState.INSTALLED) {
            return true;
        }
        if (upstream.getState() == IntegrationState.UNKNOWN) {
            return upstream.getLastStateChangeDate().toInstant().plus(this.unknownStateLeeway).compareTo(this.clock.instant()) > 0;
        }
        return false;
    }

    @VisibleForTesting
    protected AuthResult<T> doCachedRemoteAuthentication(@Nonnull AuthCacheKey cacheKey, @Nonnull Supplier<AuthResult<T>> remoteAuthentication) {
        Objects.requireNonNull(cacheKey, "cacheKey");
        Objects.requireNonNull(remoteAuthentication, "remoteAuthentication");
        try {
            return this.getRecentResultOrDoRemoteAuthentication(cacheKey, remoteAuthentication);
        }
        catch (UpstreamRequestFailedException e) {
            return this.recoverWithFallbackResultOrRethrow(cacheKey, e);
        }
    }

    private Cache<AuthCacheKey, AuthResult<T>> createFallbackAuthCache(MirroringConfig config, CacheFactory cacheFactory, String upstreamId) {
        int fallbackAuthCacheMaxEntries;
        long fallbackAuthCacheTtl = config.getFallbackAuthCacheTtl();
        int n = fallbackAuthCacheMaxEntries = config.getFallbackAuthCacheMaxEntries() < 0 ? Integer.MAX_VALUE : config.getFallbackAuthCacheMaxEntries();
        if (fallbackAuthCacheTtl > 0L && fallbackAuthCacheMaxEntries != 0) {
            return cacheFactory.getCache("bbs.mirror." + upstreamId + ".auth.fallback", null, new CacheSettingsBuilder().local().expireAfterWrite(fallbackAuthCacheTtl, TimeUnit.SECONDS).maxEntries(fallbackAuthCacheMaxEntries).build());
        }
        return null;
    }

    private Cache<AuthCacheKey, AuthResult<T>> createRecentAuthCache(MirroringConfig config, CacheFactory cacheFactory, String upstreamId) {
        int recentAuthCacheMaxEntries;
        long recentAuthCacheTtl = config.getRecentAuthCacheTtl();
        int n = recentAuthCacheMaxEntries = config.getRecentAuthCacheMaxEntries() < 0 ? Integer.MAX_VALUE : config.getRecentAuthCacheMaxEntries();
        if (recentAuthCacheTtl > 0L && recentAuthCacheMaxEntries != 0) {
            return cacheFactory.getCache("bbs.mirror." + upstreamId + ".auth.recent", null, new CacheSettingsBuilder().local().expireAfterWrite(recentAuthCacheTtl, TimeUnit.SECONDS).maxEntries(recentAuthCacheMaxEntries).build());
        }
        return null;
    }

    @Nonnull
    private AuthResult<T> getRecentResultOrDoRemoteAuthentication(@Nonnull AuthCacheKey cacheKey, @Nonnull Supplier<AuthResult<T>> remoteAuthentication) {
        MutableBoolean cacheHit = new MutableBoolean(true);
        String upstreamDesc = this.upstream.getBaseUrl();
        String cacheKeyDesc = cacheKey.toString();
        Supplier fallbackCacheUpdatingRemoteAuthentication = () -> {
            cacheHit.setFalse();
            log.trace("{}: recent auth cache - cache miss for {} - performing auth operation", (Object)upstreamDesc, (Object)cacheKeyDesc);
            AuthResult result = (AuthResult)remoteAuthentication.get();
            if (this.fallbackAuthCache != null) {
                log.trace("{}: fallback auth cache - storing new value for {} of {}", new Object[]{upstreamDesc, cacheKeyDesc, result});
                this.fallbackAuthCache.put((Object)cacheKey, (Object)result);
            }
            return result;
        };
        if (this.recentAuthCache == null) {
            return (AuthResult)fallbackCacheUpdatingRemoteAuthentication.get();
        }
        try {
            AuthResult result = (AuthResult)this.recentAuthCache.get((Object)cacheKey, fallbackCacheUpdatingRemoteAuthentication);
            if (cacheHit.booleanValue()) {
                log.debug("{}: recent auth cache - cache hit for {} with value {} - serving result from cache", new Object[]{upstreamDesc, cacheKeyDesc, result});
            }
            return result;
        }
        catch (CacheException e) {
            throw Throwables.propagate((Throwable)(e.getCause() == null ? e : e.getCause()));
        }
    }

    @Nonnull
    private AuthResult<T> recoverWithFallbackResultOrRethrow(@Nonnull AuthCacheKey cacheKey, @Nonnull UpstreamRequestFailedException exception) {
        if (this.fallbackAuthCache == null) {
            throw exception;
        }
        log.info("{}: exception occurred while performing authentication. Attempting to recover with fallback cache", (Object)this.upstream.getBaseUrl(), (Object)exception);
        AuthResult result = (AuthResult)this.fallbackAuthCache.get((Object)cacheKey);
        if (result == null) {
            log.debug("{}: fallback auth cache - cache miss for {} - rethrowing exception", (Object)this.upstream.getBaseUrl(), (Object)cacheKey);
            throw exception;
        }
        log.debug("{}: fallback auth cache - cache hit for {} with value {} - recovering from exception and serving result from cache", new Object[]{this.upstream.getBaseUrl(), cacheKey, result});
        return result;
    }
}

