/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache;

import com.atlassian.bitbucket.event.repository.RepositoryCreatedEvent;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticatorFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CachingUpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHashingService;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.cache.CacheFactory;
import com.atlassian.event.api.EventListener;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class CachingAuthenticatorFactory
implements UpstreamAuthenticatorFactory {
    private final CacheFactory cacheFactory;
    private final MirroringConfig config;
    private final CredentialsHashingService hashingService;
    private final UpstreamAuthenticatorFactory restAuthenticatorFactory;
    private final Map<String, CachingUpstreamAuthenticator> upstreamAuthenticators;

    public CachingAuthenticatorFactory(@Nonnull CacheFactory cacheFactory, @Nonnull MirroringConfig config, @Nonnull CredentialsHashingService hashingService, @Nonnull UpstreamAuthenticatorFactory restAuthenticatorFactory) {
        this.cacheFactory = cacheFactory;
        this.config = config;
        this.hashingService = hashingService;
        this.restAuthenticatorFactory = restAuthenticatorFactory;
        this.upstreamAuthenticators = new ConcurrentHashMap<String, CachingUpstreamAuthenticator>();
    }

    @Override
    @Nonnull
    public UpstreamAuthenticator create(@Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(upstream, "upstream");
        if (this.config.isAuthCachingEnabled()) {
            return this.upstreamAuthenticators.computeIfAbsent(upstream.getId(), upstreamId -> new CachingUpstreamAuthenticator(upstream, this.cacheFactory, Clock.systemUTC(), this.config, this.restAuthenticatorFactory.create(upstream), this.hashingService));
        }
        return this.restAuthenticatorFactory.create(upstream);
    }

    @EventListener
    public void onRepositoryCreated(@Nonnull RepositoryCreatedEvent event) {
        if (this.config.isAuthCachingInvalidationEnabled()) {
            this.upstreamAuthenticators.values().forEach(CachingUpstreamAuthenticator::emptyRecentAuthCache);
        }
    }
}

