/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache;

import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.DelegatedAuthenticationFailureException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.AuthCacheKey;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.AuthResult;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.BaseCachingAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHashingService;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.cache.CacheFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CachingUpstreamAuthenticator
extends BaseCachingAuthenticator<ApplicationUserWithPermissions> {
    private static final Logger log = LoggerFactory.getLogger(CachingUpstreamAuthenticator.class);
    private final UpstreamAuthenticator delegate;

    CachingUpstreamAuthenticator(@Nonnull UpstreamServer upstream, @Nonnull CacheFactory cacheFactory, @Nonnull Clock clock, @Nonnull MirroringConfig config, @Nonnull UpstreamAuthenticator delegate, @Nonnull CredentialsHashingService hashingService) {
        super(upstream, cacheFactory, clock, config, hashingService);
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String username, @Nonnull String password, Integer repoId) {
        AuthCacheKey cacheKey = new AuthCacheKey.Builder().withCredentialsHash(this.hashingService.hash(username, password)).withRepository(repoId).build();
        AuthResult authResult = this.doCachedRemoteAuthentication(cacheKey, () -> this.authenticateUserViaRest(username, password, repoId));
        return (ApplicationUserWithPermissions)authResult.getValue();
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String token, @Nullable Integer repoId) {
        AuthCacheKey cacheKey = new AuthCacheKey.Builder().withCredentialsHash(this.hashingService.hash(token)).withRepository(repoId).build();
        AuthResult authResult = this.doCachedRemoteAuthentication(cacheKey, () -> this.authenticateUserViaRest(token, repoId));
        return (ApplicationUserWithPermissions)authResult.getValue();
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateUser(@Nonnull String username, @Nonnull PublicKey publicKey) {
        AuthCacheKey cacheKey = new AuthCacheKey.Builder().withCredentialsHash(this.hashingService.hash(username, publicKey)).build();
        AuthResult authResult = this.doCachedRemoteAuthentication(cacheKey, () -> this.authenticateUserViaRest(username, publicKey));
        return (ApplicationUserWithPermissions)authResult.getValue();
    }

    protected void emptyRecentAuthCache() {
        if (this.recentAuthCache != null) {
            log.trace("{}: recent auth cache - removing all entries as a new repository has been created ", (Object)this.upstream.getBaseUrl());
            this.recentAuthCache.removeAll();
        }
    }

    private AuthResult<ApplicationUserWithPermissions> authenticateUserViaRest(@Nonnull String username, @Nonnull String password, Integer repoId) {
        try {
            ApplicationUserWithPermissions user = this.delegate.authenticateUser(username, password, repoId);
            if (log.isTraceEnabled()) {
                log.trace("{}: permissions cache - auth success with username/password - setting/updating cached permissions for user ''{}'' (id = {})", new Object[]{this.upstream.getBaseUrl(), user.getName(), user.getId()});
            }
            return new ServerAuthSuccess(user);
        }
        catch (DelegatedAuthenticationFailureException e) {
            return new ServerAuthFailure(e);
        }
    }

    private AuthResult<ApplicationUserWithPermissions> authenticateUserViaRest(@Nonnull String token, Integer repoId) {
        try {
            ApplicationUserWithPermissions user = this.delegate.authenticateUser(token, repoId);
            if (log.isTraceEnabled()) {
                log.trace("{}: permissions cache - auth success with HTTP token - setting/updating cached permissions for user ''{}'' (id = {})", new Object[]{this.upstream.getBaseUrl(), user.getName(), user.getId()});
            }
            return new ServerAuthSuccess(user);
        }
        catch (DelegatedAuthenticationFailureException e) {
            return new ServerAuthFailure(e);
        }
    }

    private AuthResult<ApplicationUserWithPermissions> authenticateUserViaRest(@Nonnull String username, @Nonnull PublicKey publicKey) {
        try {
            ApplicationUserWithPermissions user = this.delegate.authenticateUser(username, publicKey);
            if (log.isTraceEnabled()) {
                log.trace("{}: permissions cache - auth success with username/public key - setting/updating cached permissions for user ''{}'' (id = {})", new Object[]{this.upstream.getBaseUrl(), user.getName(), user.getId()});
            }
            return new ServerAuthSuccess(user);
        }
        catch (DelegatedAuthenticationFailureException e) {
            return new ServerAuthFailure(e);
        }
    }

    @VisibleForTesting
    static class ServerAuthSuccess
    extends AuthResult<ApplicationUserWithPermissions> {
        ServerAuthSuccess(@Nonnull ApplicationUserWithPermissions value) {
            super(value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").addValue((Object)"Auth success").toString();
        }
    }

    @VisibleForTesting
    static class ServerAuthFailure
    extends AuthResult<ApplicationUserWithPermissions> {
        private final DelegatedAuthenticationFailureException exception;

        ServerAuthFailure(@Nonnull DelegatedAuthenticationFailureException value) {
            super(null);
            this.exception = value;
        }

        @Override
        public ApplicationUserWithPermissions getValue() {
            throw this.exception;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").addValue((Object)"Auth failure").addValue((Object)MoreObjects.toStringHelper((String)"").addValue((Object)((Object)((Object)this.exception)).getClass().getSimpleName()).addValue((Object)this.exception.getMessage()).toString()).toString();
        }
    }
}

