/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache;

import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHash;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.cache.CredentialsHashingService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SshUtils;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PublicKeyEncodingHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="credentialsHashingService")
public class DefaultCredentialsHashingService
implements CredentialsHashingService {
    private final byte[] salt = new byte[64];
    private final PublicKeyEncodingHelper publicKeyHelper;

    @Autowired
    public DefaultCredentialsHashingService(PublicKeyEncodingHelper publicKeyHelper) {
        this.publicKeyHelper = publicKeyHelper;
        new SecureRandom().nextBytes(this.salt);
    }

    @Override
    @Nonnull
    public CredentialsHash hash(@Nonnull String token) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)token), (Object)"token must be non-blank");
        return new BearerTokenHash(this.saltedHash(token));
    }

    @Override
    @Nonnull
    public CredentialsHash hash(@Nonnull String username, @Nonnull String password) {
        Objects.requireNonNull(username, "username");
        Objects.requireNonNull(password, "password");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username), (Object)"username must be non-blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)password), (Object)"password must be non-blank");
        return new UsernameAndPasswordHash(username, this.saltedHash(password));
    }

    @Override
    @Nonnull
    public CredentialsHash hash(@Nonnull String sshUsername, @Nonnull PublicKey publicKey) {
        Objects.requireNonNull(sshUsername, "sshUsername");
        Objects.requireNonNull(publicKey, "publicKey");
        String keyText = this.publicKeyHelper.encodeAsOpenSsh(publicKey);
        String keyTextStub = SshUtils.toStub(keyText);
        String keyTextHash = this.saltedHash(keyText);
        return new SshUsernameAndPublicKeyHash(sshUsername, new PublicKeyHash(keyTextHash, keyTextStub));
    }

    String saltedHash(@Nonnull String value) {
        return Hashing.sha256().newHasher().putBytes(this.salt).putString((CharSequence)Objects.requireNonNull(value, "value"), StandardCharsets.UTF_8).hash().toString();
    }

    @VisibleForTesting
    static class BearerTokenHash
    implements CredentialsHash {
        private final String tokenHash;

        BearerTokenHash(String tokenHash) {
            this.tokenHash = tokenHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BearerTokenHash that = (BearerTokenHash)o;
            return com.google.common.base.Objects.equal((Object)this.tokenHash, (Object)that.tokenHash);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.tokenHash});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").add("passwordHash", (Object)StringUtils.abbreviate((String)this.tokenHash, (int)8)).toString();
        }
    }

    @VisibleForTesting
    static class UsernameAndPasswordHash
    implements CredentialsHash {
        private final String username;
        private final String passwordHash;

        UsernameAndPasswordHash(String username, String passwordHash) {
            this.username = username;
            this.passwordHash = passwordHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsernameAndPasswordHash that = (UsernameAndPasswordHash)o;
            return com.google.common.base.Objects.equal((Object)this.username, (Object)that.username) && com.google.common.base.Objects.equal((Object)this.passwordHash, (Object)that.passwordHash);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.username, this.passwordHash});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").addValue((Object)this.username).add("passwordHash", (Object)StringUtils.abbreviate((String)this.passwordHash, (int)8)).toString();
        }
    }

    @VisibleForTesting
    static class SshUsernameAndPublicKeyHash
    implements CredentialsHash {
        private final String sshUsername;
        private final PublicKeyHash publicKeyHash;

        SshUsernameAndPublicKeyHash(String sshUsername, PublicKeyHash publicKeyHash) {
            this.sshUsername = sshUsername;
            this.publicKeyHash = publicKeyHash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SshUsernameAndPublicKeyHash that = (SshUsernameAndPublicKeyHash)o;
            return com.google.common.base.Objects.equal((Object)this.sshUsername, (Object)that.sshUsername) && com.google.common.base.Objects.equal((Object)this.publicKeyHash, (Object)that.publicKeyHash);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.sshUsername, this.publicKeyHash});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").addValue((Object)(this.sshUsername + "@")).addValue((Object)("\"SSH " + this.publicKeyHash.keyTextStub + "\"")).add("sha256", (Object)StringUtils.abbreviate((String)this.publicKeyHash.keyTextHash, (int)11)).toString();
        }
    }

    @VisibleForTesting
    static class PublicKeyHash
    implements CredentialsHash {
        private final String keyTextHash;
        private final String keyTextStub;

        PublicKeyHash(String keyTextHash, String keyTextStub) {
            this.keyTextHash = keyTextHash;
            this.keyTextStub = keyTextStub;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PublicKeyHash publicKey = (PublicKeyHash)o;
            return com.google.common.base.Objects.equal((Object)this.keyTextHash, (Object)publicKey.keyTextHash);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.keyTextHash});
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").addValue((Object)("\"SSH " + this.keyTextStub + "\"")).add("sha256", (Object)StringUtils.abbreviate((String)this.keyTextHash, (int)11)).toString();
        }
    }
}

