/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.http;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.DelegatedAuthenticationHandlerBase;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticatorFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.http.MirrorRepositoryUrlParser;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.bitbucket.util.DevModeUtils;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class DelegatedHttpAuthenticationHandler
extends DelegatedAuthenticationHandlerBase
implements HttpAuthenticationHandler {
    private static final String AUTH_PREFIX_BEARER = "Bearer ";
    private static final String AUTH_PREFIX_BASIC = "Basic ";
    private final DirectoryManager directoryManager;
    private final MirrorRepositoryUrlParser mirrorRepositoryUrlParser;
    private final SecurityService securityService;
    private final UserAdminService userAdminService;

    public DelegatedHttpAuthenticationHandler(UpstreamAuthenticatorFactory authenticatorFactory, DirectoryManager directoryManager, I18nService i18nService, SecurityService securityService, TransactionTemplate transactionTemplate, InternalUpstreamService upstreamService, UserAdminService userAdminService, MirrorRepositoryUrlParser mirrorRepositoryUrlParser) {
        super(authenticatorFactory, i18nService, securityService, transactionTemplate, upstreamService);
        this.directoryManager = directoryManager;
        this.mirrorRepositoryUrlParser = mirrorRepositoryUrlParser;
        this.securityService = securityService;
        this.userAdminService = userAdminService;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext context) {
        String password;
        if (!this.upstreamService.isMirror()) {
            this.log.trace("Not delegating HTTP authentication because this is not a mirror");
            return null;
        }
        boolean isBasicAuth = this.isBasicAuth(context.getRequest());
        boolean isBearerAuth = this.isBearerAuth(context.getRequest());
        if (!isBasicAuth && !isBearerAuth) {
            this.log.trace("Not delegating HTTP authentication because the credentials are of an unrecognised kind");
            return null;
        }
        String username = context.getUsername();
        String string = password = context.getCredentials() instanceof String ? (String)context.getCredentials() : null;
        if (isBasicAuth) {
            if (StringUtils.isBlank((CharSequence)username)) {
                this.log.trace("Not delegating HTTP authentication because username not provided");
                return null;
            }
            if (StringUtils.isBlank((CharSequence)password)) {
                this.log.trace("Not delegating HTTP authentication because no password provided");
                return null;
            }
        }
        String bearerToken = this.getBearerAuthHeaderValue(context.getRequest());
        if (isBearerAuth && StringUtils.isBlank((CharSequence)bearerToken)) {
            this.log.trace("Not delegating HTTP authentication because bearer token not provided");
            return null;
        }
        if (this.isDevMode() && this.isLocalEmbeddedCrowdUser(context.getUsername())) {
            this.log.trace("Not delegating HTTP authentication because we are in dev mode and user {} exists locally", (Object)context.getUsername());
            return null;
        }
        InternalUpstreamServer upstream = this.upstreamService.get();
        if (upstream == null) {
            this.log.info("Not delegating HTTP authentication because this mirror is not installed on an upstream server");
            return null;
        }
        HttpServletRequest request = context.getRequest();
        ApplicationUser user = this.authenticateServer(upstream, this.mirrorRepositoryUrlParser.getExternalRepositoryId(request), username, password, bearerToken);
        if (user == null) {
            return null;
        }
        return new AuthenticationResult.Builder(user).build();
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext context) {
    }

    @VisibleForTesting
    protected boolean isDevMode() {
        return DevModeUtils.isEnabled();
    }

    private ApplicationUser authenticateServer(UpstreamServer upstream, Integer repositoryId, @Nullable String username, @Nullable String password, @Nullable String bearerToken) {
        UpstreamAuthenticator upstreamAuthenticator = this.authenticatorFactory.create(upstream);
        if (!upstreamAuthenticator.isAvailable(upstream)) {
            return null;
        }
        ApplicationUserWithPermissions userWithPermissions = StringUtils.isBlank((CharSequence)bearerToken) ? upstreamAuthenticator.authenticateUser(username, password, repositoryId) : upstreamAuthenticator.authenticateUser(bearerToken, repositoryId);
        return this.localiseResourcePermissions(userWithPermissions);
    }

    private String getBearerAuthHeaderValue(HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader == null || !authorizationHeader.startsWith(AUTH_PREFIX_BEARER)) {
            return null;
        }
        return authorizationHeader.substring(AUTH_PREFIX_BEARER.length());
    }

    private boolean isBasicAuth(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return authorization != null && authorization.startsWith(AUTH_PREFIX_BASIC);
    }

    private boolean isBearerAuth(HttpServletRequest request) {
        String authorization = request.getHeader("Authorization");
        return authorization != null && authorization.startsWith(AUTH_PREFIX_BEARER);
    }

    private boolean isLocalEmbeddedCrowdUser(@Nullable String username) {
        if (StringUtils.isBlank((CharSequence)username)) {
            return false;
        }
        return (Boolean)this.securityService.withPermission(Permission.SYS_ADMIN, "Checking directory type during delegated authentication").call(() -> {
            String directoryName;
            DetailedUser user = this.userAdminService.getUserDetails(username);
            if (user != null && (directoryName = user.getDirectoryName()) != null) {
                try {
                    return this.directoryManager.findDirectoryByName(directoryName).getType() == DirectoryType.INTERNAL;
                }
                catch (DirectoryNotFoundException directoryNotFoundException) {
                    // empty catch block
                }
            }
            return false;
        });
    }
}

