/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.http;

import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMapping;
import com.atlassian.bitbucket.internal.mirroring.mirror.dao.AoRepositoryMappingDao;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.RepositoryUrlFragment;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MirrorRepositoryUrlParser {
    private static final Set<Pattern> REPOS_URL_PATTERNS = ImmutableSet.of((Object)Pattern.compile("/rest/mirroring/latest/mirrorRepos/(?<repoId>\\d+)/?$"), (Object)Pattern.compile("/rest/mirroring/latest/upstreamServers/([^/]+)/repos/(?<repoId>\\d+)/?$"));
    private final AoRepositoryMappingDao repositoryMappingDao;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;
    private final Supplier<UpstreamServer> upstreamServerSupplier;

    @Autowired
    public MirrorRepositoryUrlParser(RepositoryService repositoryService, AoRepositoryMappingDao repositoryMappingDao, SecurityService securityService, UpstreamService upstreamService) {
        this.repositoryMappingDao = repositoryMappingDao;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
        this.upstreamServerSupplier = Suppliers.memoizeWithExpiration(upstreamService::get, (long)10L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Nullable
    public Integer getExternalRepositoryId(@Nonnull HttpServletRequest request) {
        AoRepositoryMapping mapping;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return this.maybeGetRepositoryFromRestUrl(request.getServletPath());
        }
        Repository repository = this.getRepository(RepositoryUrlFragment.fromPathInfo((String)pathInfo));
        if (repository == null) {
            repository = this.getRepository(RepositoryUrlFragment.fromNamespacedPathInfo((String)pathInfo));
        }
        if (repository != null && (mapping = this.repositoryMappingDao.getByLocalId(repository.getId())) != null) {
            return Integer.parseInt(mapping.getExternalId());
        }
        return null;
    }

    private Repository getRepository(RepositoryUrlFragment url) {
        if (url == null) {
            return null;
        }
        return (Repository)this.securityService.withPermission(Permission.REPO_READ, "Fetching repository for the given URL").call(() -> this.repositoryService.getBySlug(url.getProjectKey(), url.getRepositorySlug()));
    }

    private Integer maybeGetRepositoryFromRestUrl(String path) {
        UpstreamServer upstreamServer = (UpstreamServer)this.upstreamServerSupplier.get();
        if (upstreamServer == null) {
            return null;
        }
        for (Pattern repoUrlPattern : REPOS_URL_PATTERNS) {
            Matcher matcher = repoUrlPattern.matcher(path);
            if (!matcher.matches()) continue;
            String repoId = matcher.group("repoId");
            AoRepositoryMapping mapping = this.repositoryMappingDao.getByUpstreamId(upstreamServer.getId(), repoId);
            try {
                return mapping != null ? Integer.valueOf(repoId) : null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }
}

