/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.auth.AbstractMirroringUserAuthenticationHandler;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringUserUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamUserHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.handshake.HandshakeChallengeService;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaims;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtClaimsUtils;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ServiceUser;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamServerUserAuthenticationHandler
extends AbstractMirroringUserAuthenticationHandler {
    private static final Logger log = LoggerFactory.getLogger(UpstreamServerUserAuthenticationHandler.class);
    private final HandshakeChallengeService handshakeChallengeService;
    private final boolean handshakeEnabled;
    private final InternalUpstreamService upstreamService;
    private final UpstreamUserHelper upstreamUserHelper;

    public UpstreamServerUserAuthenticationHandler(AuthenticationContext authenticationContext, HandshakeChallengeService handshakeChallengeService, I18nService i18nService, ApplicationPropertiesService propertiesService, TransactionTemplate transactionTemplate, InternalUpstreamService upstreamService, UpstreamUserHelper upstreamUserHelper) {
        super(authenticationContext, i18nService, transactionTemplate);
        this.handshakeChallengeService = handshakeChallengeService;
        this.upstreamService = upstreamService;
        this.upstreamUserHelper = upstreamUserHelper;
        this.handshakeEnabled = propertiesService.getPluginProperty("plugin.mirroring.handshake.enabled", true);
    }

    @Override
    @Nonnull
    protected Optional<ServiceUser> getServiceUser(@Nonnull String jwtIssuerId, @Nonnull HttpAuthenticationContext authenticationContext) {
        Objects.requireNonNull(jwtIssuerId, "jwtIssuerId");
        Objects.requireNonNull(authenticationContext, "authenticationContext");
        InternalUpstreamServer upstream = this.upstreamService.get();
        if (upstream == null) {
            log.warn("Trying to authenticate JWT request with issuer ID {} when there is no upstream server", (Object)jwtIssuerId);
            return Optional.empty();
        }
        if (!Optional.of(jwtIssuerId).equals(upstream.getIssuerId())) {
            return Optional.empty();
        }
        ServiceUser serviceUser = this.upstreamUserHelper.getUserForUpstream(upstream.getId());
        if (serviceUser == null || !serviceUser.isActive()) {
            return Optional.empty();
        }
        if (this.handshakeEnabled) {
            JwtClaimsUtils.getJwtClaims(authenticationContext.getRequest()).flatMap(JwtClaims::getHandshakeId).ifPresent(this.handshakeChallengeService::challenge);
        }
        return Optional.of(serviceUser);
    }

    @Override
    protected boolean isMirroringUser(@Nonnull ApplicationUser applicationUser) {
        Objects.requireNonNull(applicationUser, "applicationUser");
        return MirroringUserUtils.isUpstreamUser(applicationUser);
    }
}

