/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.auth.ssh;

import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.SshAuthenticationContext;
import com.atlassian.bitbucket.auth.SshAuthenticationHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.DelegatedAuthenticationHandlerBase;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.DelegatedAuthenticationSystemException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticator;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.UpstreamAuthenticatorFactory;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DelegatedSshAuthenticationHandler
extends DelegatedAuthenticationHandlerBase
implements SshAuthenticationHandler {
    public DelegatedSshAuthenticationHandler(UpstreamAuthenticatorFactory authenticatorFactory, I18nService i18nService, SecurityService securityService, TransactionTemplate transactionTemplate, InternalUpstreamService upstreamService) {
        super(authenticatorFactory, i18nService, securityService, transactionTemplate, upstreamService);
    }

    @Nullable
    public AuthenticationResult performAuthentication(@Nonnull SshAuthenticationContext authenticationContext) {
        ApplicationUser user = this.authenticate(authenticationContext);
        if (user == null) {
            return null;
        }
        return new AuthenticationResult.Builder(user).build();
    }

    @Nullable
    private ApplicationUser authenticate(@Nonnull SshAuthenticationContext context) {
        if (!this.upstreamService.isMirror()) {
            this.log.trace("Not delegating SSH authentication because this is not configured to be a mirror");
            return null;
        }
        InternalUpstreamServer upstream = this.upstreamService.get();
        if (upstream == null) {
            this.log.info("Not delegating SSH authentication because this mirror is not installed on an upstream server");
            return null;
        }
        return this.authenticateServer(upstream, context);
    }

    private ApplicationUser authenticateServer(UpstreamServer upstream, SshAuthenticationContext context) {
        UpstreamAuthenticator authenticator = this.authenticatorFactory.create(upstream);
        if (!authenticator.isAvailable(upstream)) {
            return null;
        }
        try {
            return this.localiseResourcePermissions(authenticator.authenticateUser(context.getUsername(), context.getPublicKey()));
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DelegatedAuthenticationSystemException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.unexpected", new Object[0]), e);
        }
    }
}

