/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.bootstrap;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.cluster.ClusterInformation;
import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mirror.DmzMirrorSetupHelper;
import com.atlassian.bitbucket.dmz.mirror.DmzSecretService;
import com.atlassian.bitbucket.dmz.mirror.event.MirrorBootstrappingEvent;
import com.atlassian.bitbucket.internal.mirroring.MirrorType;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.InternalUpstreamService;
import com.atlassian.bitbucket.internal.mirroring.mirror.JohnsonHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleInternalUpstreamServer;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamInstallationParameters;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.farm.UpstreamAuthenticationState;
import com.atlassian.bitbucket.mirroring.mirror.IntegrationState;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FarmBootstrapJob
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(FarmBootstrapJob.class);
    private static final String PLUGIN_KEY_MIRROR_TYPE = "mirror.type";
    private final ClusterInformation clusterInformation;
    private final JohnsonHelper johnsonHelper;
    private final MirroringConfig mirroringConfig;
    private final DmzMirrorSetupHelper mirrorSetupHelper;
    private final PluginEventManager pluginEventManager;
    private final PluginSettings pluginSettings;
    private final ApplicationPropertiesService propertiesService;
    private final DmzSecretService secretService;
    private final InternalUpstreamClientFactory upstreamClientFactory;
    private final InternalUpstreamService upstreamService;

    public FarmBootstrapJob(ClusterService clusterService, JohnsonHelper johnsonHelper, MirroringConfig mirroringConfig, DmzMirrorSetupHelper mirrorSetupHelper, PluginEventManager pluginEventManager, PluginSettingsFactory pluginSettingsFactory, ApplicationPropertiesService propertiesService, DmzSecretService secretService, InternalUpstreamClientFactory upstreamClientFactory, InternalUpstreamService upstreamService) {
        this.johnsonHelper = johnsonHelper;
        this.mirroringConfig = mirroringConfig;
        this.mirrorSetupHelper = mirrorSetupHelper;
        this.pluginEventManager = pluginEventManager;
        this.propertiesService = propertiesService;
        this.secretService = secretService;
        this.upstreamClientFactory = upstreamClientFactory;
        this.upstreamService = upstreamService;
        this.clusterInformation = clusterService.getInformation();
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("com.atlassian.bitbucket.server.bitbucket-mirroring-mirror");
    }

    public void afterPropertiesSet() {
        if (SystemUtils.IS_OS_WINDOWS && this.clusterInformation.isNetworkingEnabled()) {
            String message = "The system is configured to join a mirror farm on an unsupported operating system. Mirror farms are known not to function correctly on Windows.";
            this.johnsonHelper.addJohnsonEvent("unsupported-operating-system", message, "fatal");
            log.error(message);
            throw new IllegalStateException(message);
        }
        log.debug("Registering with the plugin event manager to listen for events");
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        log.debug("Unregistering as a listener of plugin event manager events");
        this.pluginEventManager.unregister((Object)this);
    }

    @EventListener
    public void onMirrorBootstrapping(MirrorBootstrappingEvent ignored) {
        String existingMirrorType = (String)this.pluginSettings.get(PLUGIN_KEY_MIRROR_TYPE);
        if (existingMirrorType == null) {
            this.pluginSettings.put(PLUGIN_KEY_MIRROR_TYPE, (Object)this.mirroringConfig.getMirrorType().getId());
        } else {
            this.validateMirrorType(MirrorType.fromId(existingMirrorType));
        }
        this.validateConfigPropertyAgainstFarm("setup.displayName", () -> Optional.ofNullable(this.propertiesService.getDisplayName()), "mirror.secrets.map.display.name");
        this.validateConfigPropertyAgainstFarm("setup.baseUrl", () -> Optional.ofNullable(this.propertiesService.getBaseUrl()).map(URI::toString), "mirror.secrets.map.base.url");
        this.validateConfigPropertyAgainstFarm("plugin.mirroring.upstream.url", this.mirroringConfig::getServerUpstreamUrl, "mirror.secrets.map.upstream.url");
        this.bootstrapUpstream();
    }

    private void bootstrapUpstream() {
        try {
            this.secretService.compute("mirror.secrets.map.farm.state", this::doBootstrapUpstream);
        }
        catch (Exception e) {
            String message = "Failed to bootstrap mirror node. Unable to read upstream authentication state from cluster. Please try restarting the node.";
            this.johnsonHelper.addJohnsonEvent("plugin-failed", message, "fatal");
            throw new IllegalStateException(message, e);
        }
    }

    private boolean compareAuthenticationState(@Nullable UpstreamAuthenticationState stateA, @Nullable UpstreamAuthenticationState stateB) {
        if (stateA == stateB) {
            return true;
        }
        if (stateB == null || stateA == null) {
            return false;
        }
        if (!Objects.equals(stateA.getServerId(), stateB.getServerId())) {
            return false;
        }
        SimpleInternalUpstreamServer upstreamA = stateA.getUpstreamServer();
        SimpleInternalUpstreamServer upstreamB = stateB.getUpstreamServer();
        return Objects.equals(upstreamA.getBaseUrl(), upstreamB.getBaseUrl()) && Objects.equals(upstreamA.getId(), upstreamB.getId()) && Objects.equals(upstreamA.getIssuerId(), upstreamB.getIssuerId()) && Objects.equals(upstreamA.getSharedSecret(), upstreamB.getSharedSecret()) && Objects.equals((Object)upstreamA.getState(), (Object)upstreamB.getState());
    }

    @Nullable
    @GuardedBy(value="secretService.computeSecret()")
    private UpstreamAuthenticationState doBootstrapUpstream(@Nullable UpstreamAuthenticationState farmState) {
        UpstreamAuthenticationState localState = this.getOrCreateLocalUpstreamAuthenticationState();
        if (farmState == null) {
            if (localState != null) {
                log.debug("Farm authentication state missing, sharing local authentication state with farm");
                return localState;
            }
            return null;
        }
        if (!this.compareAuthenticationState(farmState, localState)) {
            Optional<UpstreamAuthenticationState> resolution;
            if (localState != null && (resolution = this.resolveConflict(farmState, localState)).isPresent()) {
                return resolution.get();
            }
            log.debug("Local authentication state is out of date, overriding with farm authentication state");
            SimpleInternalUpstreamServer sharedUpstream = farmState.getUpstreamServer();
            this.upstreamService.upsertUpstream(sharedUpstream);
            if (sharedUpstream.getState() == IntegrationState.INSTALLED) {
                this.upstreamService.overrideUpstreamInstallationParameters(UpstreamInstallationParameters.builder().issuerId(sharedUpstream.getIssuerId().orElse("")).secret(sharedUpstream.getSharedSecret().orElse("")).build());
            }
            this.mirrorSetupHelper.setServerId(farmState.getServerId());
            this.mirrorSetupHelper.markAlreadySetup();
        } else {
            log.debug("Local authentication state matches the farm authentication state, no change necessary");
        }
        return farmState;
    }

    @Nullable
    @GuardedBy(value="secretService.computeSecret()")
    private UpstreamAuthenticationState getOrCreateLocalUpstreamAuthenticationState() {
        if (!this.propertiesService.isSetup()) {
            return null;
        }
        InternalUpstreamServer localUpstream = this.upstreamService.getOrCreateUpstream();
        String serverId = Objects.requireNonNull(this.propertiesService.getServerId(), "serverId");
        return new UpstreamAuthenticationState(serverId, new SimpleInternalUpstreamServer.Builder(localUpstream).build());
    }

    @Nonnull
    private Optional<UpstreamAuthenticationState> resolveConflict(@Nonnull UpstreamAuthenticationState farmState, @Nonnull UpstreamAuthenticationState localState) {
        InternalUpstreamClient client = this.upstreamClientFactory.create(localState.getUpstreamServer());
        try {
            client.getAnalyticsSettings();
            log.info("Authentication state conflict: verified this node's state and overriding farm state");
            return Optional.of(new UpstreamAuthenticationState(localState.getServerId(), new SimpleInternalUpstreamServer.Builder(this.upstreamService.getUpstreamOrFail()).build()));
        }
        catch (AuthorisationException | AuthenticationException | UpstreamRequestFailedException e) {
            log.warn("Authentication state conflict: attempted to verify this node's settings and failed.");
            if (EnumSet.of(IntegrationState.REMOVED, IntegrationState.PENDING, IntegrationState.INITIALIZING).contains((Object)farmState.getUpstreamServer().getState()) && EnumSet.of(IntegrationState.INSTALLED, IntegrationState.UNKNOWN).contains((Object)localState.getUpstreamServer().getState())) {
                log.info("Authentication state conflict: farm upstream state is {} and local upstream state is {}; overriding farm authentication state", (Object)farmState.getUpstreamServer().getState(), (Object)localState.getUpstreamServer().getState());
                return Optional.of(new UpstreamAuthenticationState(localState.getServerId(), new SimpleInternalUpstreamServer.Builder(this.upstreamService.getUpstreamOrFail()).build()));
            }
            return Optional.empty();
        }
    }

    private void validateConfigPropertyAgainstFarm(String propertyName, Supplier<Optional<String>> propertySupplier, String farmPropertyKey) {
        Optional<String> localProperty = propertySupplier.get();
        Optional<String> farmProperty = Optional.ofNullable((String)this.secretService.computeIfAbsent(farmPropertyKey, () -> localProperty.orElse(null)));
        if (farmProperty.isPresent() && !Objects.equals(localProperty, farmProperty)) {
            String message = "Bootstrap failure: This mirror node's property - " + propertyName + " differs from other nodes. This node: " + (String)localProperty.orElse(null) + "; farm: " + farmProperty.get() + ". Please delete the mirror's home directory and set the mirror up again.";
            this.johnsonHelper.addJohnsonEvent("plugin-failed", message, "fatal");
            throw new IllegalArgumentException(message);
        }
    }

    private void validateMirrorType(MirrorType existingMirrorType) {
        if (!this.mirroringConfig.getMirrorType().equals((Object)existingMirrorType)) {
            String message = String.format("Bootstrap failure: This mirror node is started in %s mode but it was started in %s mode in past. Please correct cluster networking related properties and set the mirror up again.", new Object[]{this.mirroringConfig.getMirrorType(), existingMirrorType});
            this.johnsonHelper.addJohnsonEvent("plugin-failed", message, "fatal");
            throw new IllegalArgumentException(message);
        }
    }
}

