/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.auth.AuthenticationException;
import com.atlassian.bitbucket.auth.SshAuthenticationExpiredKeyException;
import com.atlassian.bitbucket.auth.SshAuthenticationInsecureKeyException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRepoRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestNotSupportedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtSignedRequestFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringNavBuilder;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.mirroring.mirror.client.UpstreamClient;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.httpclient.api.UnexpectedResponseException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Multimap;
import com.google.common.net.MediaType;
import io.atlassian.util.concurrent.Promise;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUpstreamClient
implements UpstreamClient {
    protected static final ObjectMapper objectMapper = new ObjectMapper();
    protected static final JsonFactory jsonFactory = objectMapper.getFactory();
    private static final Logger log = LoggerFactory.getLogger(AbstractUpstreamClient.class);
    protected final I18nService i18nService;
    protected final JsonRenderer jsonRenderer;
    protected final MirroringNavBuilder mirroringNavBuilder;
    protected final UpstreamServer upstream;
    protected final Validator validator;
    private final HttpClient httpClient;
    private final JwtSignedRequestFactory jwtRequestFactory;

    public AbstractUpstreamClient(HttpClient httpClient, I18nService i18nService, JsonRenderer jsonRenderer, MirroringNavBuilder mirroringNavBuilder, JwtSignedRequestFactory jwtRequestFactory, UpstreamServer upstream, Validator validator) {
        this.httpClient = httpClient;
        this.i18nService = i18nService;
        this.jsonRenderer = jsonRenderer;
        this.mirroringNavBuilder = mirroringNavBuilder;
        this.jwtRequestFactory = jwtRequestFactory;
        this.upstream = upstream;
        this.validator = validator;
    }

    protected abstract void ensureEntityErrorResponseIsFromUpstream(Response var1);

    protected <T> Function<Response, T> ensureEntityErrorResponseIsFromUpstreamAndThen(Function<Response, T> andThen) {
        return andThen.compose(response -> {
            this.ensureEntityErrorResponseIsFromUpstream((Response)response);
            return response;
        });
    }

    @Override
    @Nonnull
    public Request.Builder newUnauthenticatedRequest(@Nonnull String relativePath) {
        return this.newUnauthenticatedRequest(this.mirroringNavBuilder.upstream(this.upstream).relativeToBase(relativePath));
    }

    @Override
    @Nonnull
    public Request.Builder newUnauthenticatedRequest(@Nonnull String relativePath, @Nonnull Multimap<String, String> params) {
        return this.newUnauthenticatedRequest(this.mirroringNavBuilder.upstream(this.upstream).relativeToBase(relativePath).parameters(params));
    }

    protected Promise<ExternalRepository> getRepositoryAs(@Nonnull String repoId, Class<? extends ExternalRepository> repositoryRestType) {
        MirroringUrl repoUrl = this.mirroringNavBuilder.upstream(this.upstream).repositoryById(repoId).parameter("includeDefaultBranch", true);
        ResponseTransformation transformer = (ResponseTransformation)this.repositoryEndpointResponseBuilder(repoUrl).notFound(this.ensureEntityErrorResponseIsFromUpstreamAndThen(this.returnNull())).ok(response -> (ExternalRepository)this.parseEntity((Response)response, repositoryRestType).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
        log.trace("Retrieving repository with ID ({}) from upstream", (Object)repoId);
        Promise promise = this.newAuthenticatedJsonRequest(repoUrl).get().transform(transformer);
        promise.done(repository -> log.trace("Finished retrieving repository with ID ({}) from upstream", (Object)repoId));
        promise.fail(error -> log.debug("Failed retrieving repository with ID ({}) from upstream", (Object)repoId, error));
        return promise;
    }

    protected boolean isContentType(Response response, MediaType expectedContentType) {
        return !StringUtils.isEmpty((CharSequence)response.getContentType()) && MediaType.parse((String)response.getContentType()).is(expectedContentType);
    }

    protected Request.Builder newAuthenticatedJsonRequest(MirroringUrl url) {
        return this.sendingAndAcceptingJson(this.newAuthenticatedRequest(url));
    }

    protected Request.Builder newAuthenticatedRequest(MirroringUrl url) {
        if (log.isTraceEnabled()) {
            log.trace("{}: making JWT-authenticated request to {}", MirrorDescriptionUtils.describe(this.upstream), (Object)url.getAbsolute());
        }
        return this.jwtRequestFactory.newRequest(url);
    }

    protected Request.Builder newUnauthenticatedJsonRequest(String url) {
        return this.sendingAndAcceptingJson(this.httpClient.newRequest(url));
    }

    protected Request.Builder newUnauthenticatedRequest(MirroringUrl url) {
        if (log.isTraceEnabled()) {
            log.trace("{}: making unauthenticated request to {}", MirrorDescriptionUtils.describe(this.upstream), (Object)url.getAbsolute());
        }
        return this.httpClient.newRequest(url.getAbsolute());
    }

    protected <T> Optional<T> parseEntity(Response response, Class<T> type) {
        String entity = response.getEntity();
        if (StringUtils.isBlank((CharSequence)entity)) {
            log.debug("The upstream server responded with code {} but the response entity was empty", (Object)response.getStatusCode());
            return Optional.empty();
        }
        log.trace("The upstream server responded with code {} and entity {}", (Object)response.getStatusCode(), (Object)entity);
        try {
            return Optional.of(ValidationUtils.validate((Validator)this.validator, (Object)objectMapper.readValue(entity, type), (Class[])new Class[0]));
        }
        catch (IOException e) {
            log.debug("Failed to deserialize an instance of {} from the response", (Object)type.getName(), (Object)e);
            return Optional.empty();
        }
    }

    protected <T> T ensureIsRequestFailedOrAuthException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        if (throwable instanceof UpstreamRequestFailedException) {
            throw (UpstreamRequestFailedException)((Object)throwable);
        }
        if (throwable instanceof SshAuthenticationExpiredKeyException) {
            throw (SshAuthenticationExpiredKeyException)throwable;
        }
        if (throwable instanceof SshAuthenticationInsecureKeyException) {
            throw (SshAuthenticationInsecureKeyException)throwable;
        }
        if (throwable instanceof AuthenticationException) {
            throw (AuthenticationException)throwable;
        }
        if (throwable instanceof AuthorisationException) {
            throw (AuthorisationException)throwable;
        }
        String message = this.extractMessage(throwable);
        if (throwable.getClass() == RuntimeException.class) {
            throwable = throwable.getCause() == null ? throwable : throwable.getCause();
        }
        throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed", new Object[]{message}), throwable);
    }

    protected <T> Function<Response, T> returnNull() {
        return notFoundResponse -> null;
    }

    protected Request.Builder sendingAndAcceptingJson(Request.Builder builder) {
        return ((Request.Builder)builder.setContentType(MediaType.JSON_UTF_8.toString())).setAccept("application/json");
    }

    protected <T> ResponseTransformation.Builder<T> repositoryEndpointResponseBuilder(MirroringUrl url) {
        return DefaultResponseTransformation.builder().unauthorized(this::throwRequestUntrusted).on(HttpStatus.TOO_MANY_REQUESTS, response -> this.throwRepoReqRateExceeded(url)).others(this::throwRequestFailedUnexpectedResponse).fail(this::ensureIsRequestFailedOrAuthException);
    }

    protected <T> ResponseTransformation.Builder<T> standardResponseBuilder(MirroringUrl url) {
        return DefaultResponseTransformation.builder().unauthorized(this::throwRequestUntrusted).on(HttpStatus.TOO_MANY_REQUESTS, response -> this.throwReqRateExceeded(url)).others(this::throwRequestFailedUnexpectedResponse).fail(this::ensureIsRequestFailedOrAuthException);
    }

    protected UpstreamRequestFailedException newRequestFailedUnexpectedResponseException(Response response) {
        return new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.response.unexpected", new Object[]{response.getStatusCode(), response.getStatusText()}));
    }

    protected Supplier<UpstreamRequestFailedException> requestFailedUnexpectedResponseSupplier(Response response) {
        return () -> this.newRequestFailedUnexpectedResponseException(response);
    }

    protected <T> T throwRepoReqRateExceeded(MirroringUrl url) {
        throw new UpstreamRepoRequestRateExceededException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.repo.rate.exceeded", new Object[]{MirrorDescriptionUtils.describe(this.upstream), URI.create(url.getAbsolute()).getPath()}));
    }

    protected <T> T throwReqRateExceeded(MirroringUrl url) {
        throw new UpstreamRequestRateExceededException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.rate.exceeded", new Object[]{MirrorDescriptionUtils.describe(this.upstream), URI.create(url.getAbsolute()).getPath()}));
    }

    protected <T> T throwRequestFailedUnexpectedResponse(Response response) {
        throw this.newRequestFailedUnexpectedResponseException(response);
    }

    protected <T> T throwRequestUntrusted(Response response) {
        throw new UpstreamRequestUntrustedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.untrusted.mirror", new Object[]{response.getStatusCode(), response.getStatusText()}));
    }

    protected <T> T throwUnsupportedOperation(String operation) {
        throw new UpstreamRequestNotSupportedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.unsupported", new Object[]{operation}));
    }

    private String extractMessage(Throwable throwable) {
        String message = null;
        if (throwable instanceof UnexpectedResponseException) {
            message = throwable.toString();
        }
        if (message == null) {
            message = throwable.getMessage();
        }
        return message;
    }
}

