/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.internal.mirroring.MirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.BackoffUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.Sleeper;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamRepositoryHashesCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.mirroring.MirroringCapabilities;
import com.atlassian.bitbucket.mirroring.mirror.AnalyticsSettings;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.httpclient.api.Request;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Multimap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.PublicKey;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRetryingUpstreamClient
implements InternalUpstreamClient {
    @VisibleForTesting
    static final int MAX_ATTEMPTS = 5;
    private static final Logger log = LoggerFactory.getLogger(AuthRetryingUpstreamClient.class);
    private final InternalUpstreamClient delegate;
    private final Sleeper sleeper;

    public AuthRetryingUpstreamClient(@Nonnull InternalUpstreamClient delegate, @Nonnull Sleeper sleeper) {
        this.delegate = Objects.requireNonNull(delegate, "delegate");
        this.sleeper = Objects.requireNonNull(sleeper, "sleeper");
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String username, @Nonnull String password, @Nullable Integer repoId) {
        return this.retry(() -> this.delegate.authenticateForUser(Objects.requireNonNull(username, "username"), Objects.requireNonNull(password, "password"), repoId), "authenticateForUser");
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String token, @Nullable Integer repoId) {
        return this.retry(() -> this.delegate.authenticateForUser(Objects.requireNonNull(token, "token"), repoId), "authenticateForUser");
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String username, @Nonnull PublicKey publicKey) {
        return this.retry(() -> this.delegate.authenticateForUser(username, publicKey), "authenticateForUser");
    }

    @Override
    public void deleteSshKeys() {
        this.retry(this.delegate::deleteSshKeys, "deleteSshKeys");
    }

    @Override
    @Nonnull
    public AnalyticsSettings getAnalyticsSettings() {
        return this.delegate.getAnalyticsSettings();
    }

    @Override
    @Nonnull
    public MirroringCapabilities getCapabilities() {
        return this.delegate.getCapabilities();
    }

    @Override
    @Nonnull
    public ExternalProject getProject(@Nonnull String projectId) {
        return this.retry(() -> this.delegate.getProject(Objects.requireNonNull(projectId, "projectId")), "getProject");
    }

    @Override
    @Nonnull
    public Stream<ExternalRepository> getRepositories() {
        return this.retry(this.delegate::getRepositories, "getRepositories");
    }

    @Override
    @Nonnull
    public Stream<ExternalRepository> getRepositoriesByProjectId(@Nonnull String projectId) {
        return this.retry(() -> this.delegate.getRepositoriesByProjectId(Objects.requireNonNull(projectId, "projectId")), "getRepositoriesByProjectId");
    }

    @Override
    @Nonnull
    public ExternalRepository getRepository(@Nonnull String repoId) {
        return this.retry(() -> this.delegate.getRepository(Objects.requireNonNull(repoId, "repoId")), "getRepository");
    }

    @Override
    @Nonnull
    public UpstreamSshSettings getSshSettings() {
        return this.retry(this.delegate::getSshSettings, "getSshSettings");
    }

    @Override
    @Nullable
    public String getUpstreamHandshakeId() {
        return this.retry(this.delegate::getUpstreamHandshakeId, "getUpstreamHandshakeId");
    }

    @Override
    @Nonnull
    public boolean isMirrorInstalled() {
        return this.delegate.isMirrorInstalled();
    }

    @Override
    @Nonnull
    public Request.Builder newScmHttpRequest(@Nonnull String relativePath) {
        return this.retry(() -> this.delegate.newScmHttpRequest(Objects.requireNonNull(relativePath, "relativePath")), "newScmHttpRequest");
    }

    @Override
    @Nonnull
    public Request.Builder newUnauthenticatedRequest(@Nonnull String relativePath) {
        return this.delegate.newUnauthenticatedRequest(Objects.requireNonNull(relativePath, "relativePath"));
    }

    @Override
    @Nonnull
    public Request.Builder newUnauthenticatedRequest(@Nonnull String relativePath, @Nonnull Multimap<String, String> params) {
        return this.delegate.newUnauthenticatedRequest(Objects.requireNonNull(relativePath, "relativePath"), Objects.requireNonNull(params, "params"));
    }

    @Override
    public void notifyRepositorySynchronizationFailed(@Nonnull RepositorySynchronizationFailedOnFarmEvent event, @Nonnull String externalRepositoryId) {
        this.retry(() -> this.delegate.notifyRepositorySynchronizationFailed(Objects.requireNonNull(event, "event"), Objects.requireNonNull(externalRepositoryId, "externalRepositoryId")), "notifyRepositorySynchronizationFailed");
    }

    @Override
    public void notifyRepositorySynchronized(@Nonnull RepositorySynchronizedOnFarmEvent event, @Nonnull String externalRepositoryId) {
        this.retry(() -> this.delegate.notifyRepositorySynchronized(Objects.requireNonNull(event, "event"), Objects.requireNonNull(externalRepositoryId, "externalRepositoryId")), "notifyRepositorySynchronized");
    }

    @Override
    public void refreshContentHash(@Nonnull String externalRepositoryId) {
        this.retry(() -> this.delegate.refreshContentHash(Objects.requireNonNull(externalRepositoryId, "externalRepositoryId")), "requestHashUpdate");
    }

    @Override
    public void registerAsMirror(@Nonnull MirroringRequest request) {
        this.retry(() -> this.delegate.registerAsMirror(Objects.requireNonNull(request, "request")), "registerAsMirror");
    }

    @Override
    public int streamHashes(@Nonnull UpstreamRepositoryHashesCallback callback) {
        return this.retry(() -> this.delegate.streamHashes(Objects.requireNonNull(callback, "callback")), "streamHashes");
    }

    @Override
    public void upgradeMirror(@Nonnull MirrorUpgradeRequest request) {
        this.retry(() -> this.delegate.upgradeMirror(Objects.requireNonNull(request, "request")), "upgradeMirror");
    }

    @Override
    public void uploadSshKey(@Nonnull String key) {
        this.retry(() -> this.delegate.uploadSshKey(Objects.requireNonNull(key, "key")), "uploadSshKey");
    }

    private int handleUntrusted(String operation, int attempt, UpstreamRequestUntrustedException e) {
        if (attempt >= 5) {
            log.error("{} attempts to upstream for {} failed authorization, giving up", new Object[]{5, operation, e});
            throw e;
        }
        long delay = BackoffUtils.exponentialDelay(1000L, attempt);
        log.debug("Upstream request untrusted for {} attempt {}/{} trying again in {} ms", new Object[]{operation, attempt++, 5, delay});
        this.sleeper.sleep(delay);
        return attempt;
    }

    private void retry(Runnable runnable, String operation) {
        int attempt = 1;
        while (attempt <= 5) {
            try {
                runnable.run();
                break;
            }
            catch (UpstreamRequestUntrustedException e) {
                attempt = this.handleUntrusted(operation, attempt, e);
            }
        }
    }

    private <R> R retry(Supplier<R> supplier, String operation) {
        int attempt = 1;
        while (attempt <= 5) {
            try {
                return supplier.get();
            }
            catch (UpstreamRequestUntrustedException e) {
                attempt = this.handleUntrusted(operation, attempt, e);
            }
        }
        throw new IllegalStateException("");
    }
}

