/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.auth.CaptchaRequiredAuthenticationException;
import com.atlassian.bitbucket.auth.SshAuthenticationExpiredKeyException;
import com.atlassian.bitbucket.auth.SshAuthenticationInsecureKeyException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.internal.mirroring.ConstraintViolationUtils;
import com.atlassian.bitbucket.internal.mirroring.MirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.MirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.ExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorDescriptionUtils;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorKeyUploadFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirrorRegistrationFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.SimpleAnalyticsSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestFailedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestRateExceededException;
import com.atlassian.bitbucket.internal.mirroring.mirror.UpstreamRequestUntrustedException;
import com.atlassian.bitbucket.internal.mirroring.mirror.auth.DelegatedAuthenticationFailureException;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.AbstractUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.ServerRepositoryHashParser;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.UpstreamRepositoryHashesCallback;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtSignedRequestFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.MirrorJwtTokenHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringNavBuilder;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringUrl;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.RestSimpleRsaSshKey;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.server.RestServerExternalProject;
import com.atlassian.bitbucket.internal.mirroring.mirror.rest.server.RestServerExternalRepository;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.SimpleUpstreamSshSettings;
import com.atlassian.bitbucket.internal.mirroring.mirror.ssh.UpstreamSshSettings;
import com.atlassian.bitbucket.internal.mirroring.rest.RestAnalyticsSettings;
import com.atlassian.bitbucket.internal.mirroring.rest.RestMirrorUpgradeRequest;
import com.atlassian.bitbucket.internal.mirroring.rest.RestMirroringCapabilities;
import com.atlassian.bitbucket.internal.mirroring.rest.RestMirroringRequest;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositorySynchronizationFailedEvent;
import com.atlassian.bitbucket.internal.mirroring.rest.RestRepositorySynchronizedEvent;
import com.atlassian.bitbucket.internal.mirroring.rest.RestUpstreamHandshakeResponse;
import com.atlassian.bitbucket.internal.mirroring.rest.RestUpstreamSshSettings;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestApplicationUserWithPermissions;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestAuthenticationRequest;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestBearerTokenCredentials;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestSshCredentials;
import com.atlassian.bitbucket.internal.mirroring.rest.auth.RestUsernamePasswordCredentials;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PublicKeyEncodingHelper;
import com.atlassian.bitbucket.internal.mirroring.user.ApplicationUserWithPermissions;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.mirroring.MirroringCapabilities;
import com.atlassian.bitbucket.mirroring.MirroringRole;
import com.atlassian.bitbucket.mirroring.RepositoryListMode;
import com.atlassian.bitbucket.mirroring.mirror.AnalyticsSettings;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizationFailedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.RepositorySynchronizedOnFarmEvent;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.net.MediaType;
import com.google.errorprone.annotations.MustBeClosed;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validator;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpstreamClient
extends AbstractUpstreamClient
implements InternalUpstreamClient {
    private static final MirroringCapabilities DEFAULT_CAPABILITIES = new MirroringCapabilities.Builder().roles((Iterable<MirroringRole>)ImmutableList.of((Object)((Object)MirroringRole.UPSTREAM))).repositoryListModes((Iterable<RepositoryListMode>)ImmutableList.of((Object)((Object)RepositoryListMode.ALL), (Object)((Object)RepositoryListMode.BY_ID))).build();
    private static final Predicate<RestErrorMessage> ERROR_WITH_CREDENTIALS_CONTEXT = input -> input != null && "credentials".equals(input.getContext()) && StringUtils.isNotEmpty((CharSequence)input.getMessage());
    private static final Predicate<RestErrorMessage> ERROR_WITH_CREDENTIALS_EXPIRED = input -> input != null && StringUtils.defaultString((String)input.getExceptionName()).toLowerCase(Locale.US).contains("sshauthenticationexpiredkeyexception") && StringUtils.isNotEmpty((CharSequence)input.getMessage());
    private static final Predicate<RestErrorMessage> ERROR_WITH_CAPTCHA_EXCEPTION = input -> input != null && StringUtils.defaultString((String)input.getExceptionName()).toLowerCase(Locale.US).contains("captcha") && StringUtils.isNotEmpty((CharSequence)input.getMessage());
    private static final Predicate<RestErrorMessage> ERROR_WITH_INSECURE_CREDENTIALS = input -> input != null && StringUtils.defaultString((String)input.getExceptionName()).toLowerCase(Locale.US).contains("sshauthenticationinsecurekeyexception") && StringUtils.isNotEmpty((CharSequence)input.getMessage());
    private static final int TOO_MANY_REQUESTS = 429;
    private static final Logger log = LoggerFactory.getLogger(DefaultUpstreamClient.class);
    private final Supplier<String> applicationName;
    private final MirroringConfig config;
    private final MirrorJwtTokenHelper mirrorJwtTokenHelper;
    private final PublicKeyEncodingHelper publicKeyHelper;
    private final ApplicationPropertiesService propertiesService;

    public DefaultUpstreamClient(MirroringConfig config, HttpClient httpClient, I18nService i18nService, JsonRenderer jsonRenderer, MirroringNavBuilder mirroringNavBuilder, MirrorJwtTokenHelper mirrorJwtTokenHelper, PublicKeyEncodingHelper publicKeyHelper, ApplicationPropertiesService propertiesService, JwtSignedRequestFactory requestFactory, UpstreamServer upstream, Validator validator) {
        super(httpClient, i18nService, jsonRenderer, mirroringNavBuilder, requestFactory, upstream, validator);
        this.config = config;
        this.publicKeyHelper = publicKeyHelper;
        this.propertiesService = propertiesService;
        this.mirrorJwtTokenHelper = mirrorJwtTokenHelper;
        this.applicationName = new DefaultApplicationNameSupplier(propertiesService);
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String username, @Nonnull String password, @Nullable Integer repoId) {
        return this.authenticateForUser(this.createAuthRequest(Objects.requireNonNull(username, "username"), Objects.requireNonNull(password, "password"), repoId));
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String token, @Nullable Integer repoId) {
        return this.authenticateForUser(this.createAuthRequest(Objects.requireNonNull(token, "token"), repoId));
    }

    @Override
    @Nonnull
    public ApplicationUserWithPermissions authenticateForUser(@Nonnull String username, @Nonnull PublicKey publicKey) {
        return this.authenticateForUser(this.createAuthRequest(Objects.requireNonNull(username, "username"), Objects.requireNonNull(publicKey, "publicKey")));
    }

    @Override
    public void deleteSshKeys() {
        MirroringUrl sshKeysUrl = this.mirroringNavBuilder.upstream(this.upstream).sshKeys();
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(sshKeysUrl).notFound(this.ensureEntityErrorResponseIsFromUpstreamAndThen(this.returnNull())).noContent(this.returnNull()).build();
        this.newAuthenticatedJsonRequest(sshKeysUrl).delete().transform(transformer).claim();
    }

    @Override
    @Nonnull
    public AnalyticsSettings getAnalyticsSettings() {
        MirroringUrl analyticsUrl = this.mirroringNavBuilder.upstream(this.upstream).analyticsSettings();
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(analyticsUrl).ok(response -> this.parseEntity((Response)response, RestAnalyticsSettings.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
        return (AnalyticsSettings)this.newAuthenticatedJsonRequest(analyticsUrl).get().transform(transformer).map(this::transformAnalyticsSettings).claim();
    }

    @Override
    @Nonnull
    public MirroringCapabilities getCapabilities() {
        MirroringUrl capabilitiesUrl = this.mirroringNavBuilder.upstream(this.upstream).capabilities();
        return (MirroringCapabilities)this.newUnauthenticatedRequest(capabilitiesUrl).get().transform(this.toCapabilities(capabilitiesUrl)).claim();
    }

    @Override
    @Nullable
    public ExternalProject getProject(@Nonnull String projectId) {
        Objects.requireNonNull(projectId, "projectId");
        MirroringUrl projectUrl = this.mirroringNavBuilder.upstream(this.upstream).projectById(projectId);
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(projectUrl).notFound(this.ensureEntityErrorResponseIsFromUpstreamAndThen(this.returnNull())).ok(response -> this.parseEntity((Response)response, RestServerExternalProject.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
        log.debug("Retrieving project with ID ({}) from upstream", (Object)projectId);
        return (ExternalProject)this.newAuthenticatedJsonRequest(projectUrl).get().transform(transformer).done(project -> log.debug("Finished retrieving project with ID ({}) from upstream", (Object)projectId)).fail(error -> log.debug("Failed retrieving project with ID ({}) from upstream", (Object)projectId, error)).claim();
    }

    @Override
    @Nonnull
    public Stream<ExternalRepository> getRepositories() {
        return MoreStreams.streamIterable((Iterable)new PagedIterable(this::getRepoPage, this.config.getUpstreamRepositoryRequestPageSize()));
    }

    @Override
    @Nonnull
    public Stream<ExternalRepository> getRepositoriesByProjectId(@Nonnull String projectId) {
        Objects.requireNonNull(projectId, "projectId");
        return MoreStreams.streamIterable((Iterable)new PagedIterable(pageRequest -> this.getRepoPageForProject(pageRequest, projectId), this.config.getUpstreamRepositoryRequestPageSize()));
    }

    @Override
    @Nonnull
    public ExternalRepository getRepository(@Nonnull String repoId) {
        return (ExternalRepository)this.getRepositoryAs(repoId, RestServerExternalRepository.class).claim();
    }

    @Override
    @Nonnull
    public UpstreamSshSettings getSshSettings() {
        MirroringUrl sshSettingsUrl = this.mirroringNavBuilder.upstream(this.upstream).sshSettings();
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(sshSettingsUrl).ok(response -> this.parseEntity((Response)response, RestUpstreamSshSettings.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).notFound(this.ensureUpstreamEndpointNotFoundAndThen(this::throwRequestFailedUnexpectedResponse)).build();
        return (UpstreamSshSettings)this.newAuthenticatedJsonRequest(sshSettingsUrl).get().transform(transformer).map(this::transformSshSettings).claim();
    }

    @Override
    @Nullable
    public String getUpstreamHandshakeId() {
        MirroringUrl handshakeChallengeUrl = this.mirroringNavBuilder.upstream(this.upstream).handshake();
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(handshakeChallengeUrl).notFound(response -> new RestUpstreamHandshakeResponse()).ok(response -> this.parseEntity((Response)response, RestUpstreamHandshakeResponse.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
        return (String)this.newAuthenticatedJsonRequest(handshakeChallengeUrl).get().transform(transformer).map(RestUpstreamHandshakeResponse::getHandshakeId).claim();
    }

    @Override
    public boolean isMirrorInstalled() {
        MirroringUrl mirrorUrl = this.mirroringNavBuilder.upstream(this.upstream).mirrors(PageUtils.newRequest((int)0, (int)250));
        String serverId = Objects.requireNonNull(this.propertiesService.getServerId(), "serverId");
        ResponseTransformation transformer = (ResponseTransformation)this.standardResponseBuilder(mirrorUrl).ok(response -> {
            Page<RestMinimalMirrorServer> mirrors = this.parseEntityPage((Response)response, (Class)RestMinimalMirrorServer.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response));
            return MoreStreams.streamIterable((Iterable)mirrors.getValues()).anyMatch(mirror -> serverId.equals(mirror.getId()));
        }).build();
        return (Boolean)this.newUnauthenticatedJsonRequest(mirrorUrl.getAbsolute()).get().transform(transformer).claim();
    }

    @Override
    @Nonnull
    public Request.Builder newScmHttpRequest(@Nonnull String relativePath) {
        return this.newAuthenticatedRequest(this.mirroringNavBuilder.upstream(this.upstream).relativeToBase(relativePath));
    }

    @Override
    public void notifyRepositorySynchronizationFailed(@Nonnull RepositorySynchronizationFailedOnFarmEvent event, @Nonnull String externalRepositoryId) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        RestRepositorySynchronizationFailedEvent restEvent = new RestRepositorySynchronizationFailedEvent(event.getRepository().getId(), externalRepositoryId);
        String jsonRequest = this.jsonRenderer.render((Object)restEvent, Collections.emptyMap());
        this.notifyUpstream(jsonRequest);
    }

    @Override
    public void notifyRepositorySynchronized(@Nonnull RepositorySynchronizedOnFarmEvent event, @Nonnull String externalRepositoryId) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        RestRepositorySynchronizedEvent restEvent = new RestRepositorySynchronizedEvent(event.getCloneLinks(), (Collection<MinimalRef>)ImmutableList.of(), event.getRepository().getId(), event.getRefChanges(), event.isRefLimitExceeded(), event.getSyncType(), externalRepositoryId);
        String jsonRequest = this.jsonRenderer.render((Object)restEvent, Collections.emptyMap());
        this.notifyUpstream(jsonRequest);
    }

    @Override
    public void refreshContentHash(@Nonnull String externalRepositoryId) {
        Objects.requireNonNull(externalRepositoryId, "externalRepositoryId");
        MirroringUrl url = this.mirroringNavBuilder.upstream(this.upstream).repositoryHashes().refreshContentHash(externalRepositoryId);
        this.newAuthenticatedJsonRequest(url).post().claim();
    }

    @Override
    public void registerAsMirror(@Nonnull MirroringRequest request) {
        Objects.requireNonNull(request, "request");
        try {
            ValidationUtils.validate((Validator)this.validator, (Object)request, (Class[])new Class[0]);
        }
        catch (ConstraintViolationException e) {
            Promises.rejected((Throwable)((Object)new MirrorRegistrationFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.registration.invalid", new Object[]{request, ConstraintViolationUtils.violationToString(e), e})))).claim();
        }
        String jsonRequest = this.jsonRenderer.render((Object)new RestMirroringRequest(request), Collections.emptyMap());
        String registrationUrl = this.upstream.getBaseUrl();
        if (!registrationUrl.endsWith("/requests")) {
            registrationUrl = this.mirroringNavBuilder.upstream(this.upstream).mirrorRequests().getAbsolute();
        }
        ((Request.Builder)this.newUnauthenticatedJsonRequest(registrationUrl).setEntity(jsonRequest)).post().fold(this.wrapAsOrRethrowIfSame(MirrorRegistrationFailedException.class, "bitbucket.mirroring.upstream.registration.error", MirrorRegistrationFailedException::new), response -> {
            if (!(response.isOk() || response.isCreated() || response.isNoContent())) {
                throw new MirrorRegistrationFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.registration.failed", new Object[]{response.getStatusCode(), response.getStatusText()}));
            }
            return null;
        }).claim();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int streamHashes(@Nonnull UpstreamRepositoryHashesCallback callback) {
        Objects.requireNonNull(callback, "callback");
        MirroringUrl hashesUrl = this.mirroringNavBuilder.upstream(this.upstream).repositoryHashes().streamAll();
        try (InputStream responseStream = this.openConnectionAndStream(hashesUrl);){
            int n;
            block14: {
                JsonParser jsonParser = jsonFactory.createJsonParser(responseStream);
                try {
                    n = new ServerRepositoryHashParser(jsonParser).stream(callback);
                    if (jsonParser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (jsonParser != null) {
                        try {
                            jsonParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                jsonParser.close();
            }
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void upgradeMirror(@Nonnull MirrorUpgradeRequest request) {
        Objects.requireNonNull(request, "request");
        String jsonRequest = this.jsonRenderer.render((Object)new RestMirrorUpgradeRequest(request), Collections.emptyMap());
        MirroringUrl url = this.mirroringNavBuilder.upstream(this.upstream).mirror(this.propertiesService.getServerId());
        ((Request.Builder)this.newAuthenticatedJsonRequest(url).setEntity(jsonRequest)).put().transform((ResponseTransformation)this.standardResponseBuilder(url).on(HttpStatus.METHOD_NOT_ALLOWED, response -> (Void)this.throwUnsupportedOperation("upgrade")).on(HttpStatus.FORBIDDEN, response -> (Void)this.throwUnsupportedOperation("upgrade")).ok(this.returnNull()).build()).claim();
    }

    @Override
    public void uploadSshKey(@Nonnull String key) {
        Objects.requireNonNull(key, "key");
        String jsonKey = this.jsonRenderer.render((Object)new RestSimpleRsaSshKey(key), Collections.emptyMap());
        ((Request.Builder)this.newAuthenticatedJsonRequest(this.mirroringNavBuilder.upstream(this.upstream).sshKeys()).setEntity(jsonKey)).post().fold(this.wrapAsOrRethrowIfSame(MirrorKeyUploadFailedException.class, "bitbucket.mirroring.upstream.upload.ssh.error", MirrorKeyUploadFailedException::new), response -> {
            if (log.isTraceEnabled()) {
                log.trace("The upstream's SSH keys endpoint responded with status code {} and body:\n{}", (Object)response.getStatusCode(), (Object)response.getEntity());
            }
            if (!response.isCreated()) {
                log.debug("Failed to add SSH key to the upstream. Status code: {}", (Object)response.getStatusCode());
                throw new MirrorKeyUploadFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.upload.ssh.failed", new Object[]{response.getStatusCode(), response.getStatusText()}));
            }
            return null;
        }).claim();
    }

    @Override
    protected void ensureEntityErrorResponseIsFromUpstream(Response response) {
        this.ensureContentType(response, MediaType.JSON_UTF_8);
    }

    private ApplicationUserWithPermissions authenticateForUser(RestAuthenticationRequest authRequest) {
        Objects.requireNonNull(authRequest, "authRequest");
        MirroringUrl authenticateUrl = this.mirroringNavBuilder.upstream(this.upstream).authenticate();
        if (log.isDebugEnabled()) {
            log.debug("Delegated authentication endpoint: {}", (Object)authenticateUrl.getAbsolute());
        }
        String jsonRequest = this.jsonRenderer.render((Object)authRequest, Collections.emptyMap());
        ResponseTransformation transformer = (ResponseTransformation)DefaultResponseTransformation.builder().on(429, response -> (ApplicationUserWithPermissions)this.throwReqRateExceeded(authenticateUrl)).others(this::parseAuthenticationResponse).fail(this::ensureIsRequestFailedOrAuthException).build();
        return (ApplicationUserWithPermissions)((Request.Builder)this.newAuthenticatedJsonRequest(authenticateUrl).setEntity(jsonRequest)).post().transform(transformer).claim();
    }

    private RestAuthenticationRequest createAuthRequest(String username, PublicKey publicKey) {
        return new RestAuthenticationRequest(new RestSshCredentials(username, this.publicKeyHelper.encodeAsOpenSsh(publicKey)));
    }

    private RestAuthenticationRequest createAuthRequest(String token, Integer repoId) {
        return new RestAuthenticationRequest(new RestBearerTokenCredentials(token), repoId);
    }

    private RestAuthenticationRequest createAuthRequest(String username, String password, Integer repoId) {
        return new RestAuthenticationRequest(new RestUsernamePasswordCredentials(username, password), repoId);
    }

    private void ensureContentType(Response response, MediaType contentType) {
        try {
            if (this.isContentType(response, contentType.withoutParameters())) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        throw this.newRequestFailedUnexpectedResponseException(response);
    }

    private <T> Function<Response, T> ensureUpstreamEndpointNotFoundAndThen(Function<Response, T> andThen) {
        return andThen.compose(response -> {
            this.ensureUpstreamEndpointNotFound((Response)response);
            return response;
        });
    }

    private void ensureUpstreamEndpointNotFound(Response response) {
        this.ensureContentType(response, MediaType.APPLICATION_XML_UTF_8);
    }

    private RestErrorMessage findFirstNonEmptyError(RestErrors restErrors) {
        return restErrors == null ? null : (RestErrorMessage)restErrors.getErrors().stream().filter(errorMessage -> StringUtils.isNotEmpty((CharSequence)errorMessage.getMessage())).findFirst().orElse(null);
    }

    private RestErrorMessage findUserCaptchaError(RestErrors restErrors) {
        return restErrors == null ? null : (RestErrorMessage)Iterables.find((Iterable)restErrors.getErrors(), ERROR_WITH_CAPTCHA_EXCEPTION::test, null);
    }

    private RestErrorMessage findUserCredentialsError(RestErrors restErrors) {
        return restErrors == null ? null : (RestErrorMessage)Iterables.find((Iterable)restErrors.getErrors(), ERROR_WITH_CREDENTIALS_CONTEXT::test, null);
    }

    private RestErrorMessage findUserCredentialsExpiredError(RestErrors restErrors) {
        return restErrors == null ? null : (RestErrorMessage)Iterables.find((Iterable)restErrors.getErrors(), ERROR_WITH_CREDENTIALS_EXPIRED::test, null);
    }

    private RestErrorMessage findUserCredentialsInsecureError(RestErrors restErrors) {
        return restErrors == null ? null : (RestErrorMessage)Iterables.find((Iterable)restErrors.getErrors(), ERROR_WITH_INSECURE_CREDENTIALS::test, null);
    }

    @Nonnull
    private Page<ExternalRepository> getRepoPage(@Nonnull PageRequest pageRequest) {
        MirroringUrl reposUrl = this.mirroringNavBuilder.upstream(this.upstream).repositories(pageRequest);
        log.debug("Retrieving page [start={}, limit={}] of upstream repositories", (Object)pageRequest.getStart(), (Object)pageRequest.getLimit());
        Promise promise = this.newAuthenticatedJsonRequest(reposUrl).get().transform(this.toPageOfRepos(reposUrl)).done(page -> log.debug("Finished retrieving page [start={}, limit={}] of upstream repositories", (Object)pageRequest.getStart(), (Object)pageRequest.getLimit())).fail(error -> log.debug("Failed retrieving page [start={}, limit={}] of upstream repositories", new Object[]{pageRequest.getStart(), pageRequest.getLimit(), error}));
        return (Page)promise.claim();
    }

    private Page<ExternalRepository> getRepoPageForProject(@Nonnull PageRequest pageRequest, @Nonnull String projectId) {
        MirroringUrl reposUrl = this.mirroringNavBuilder.upstream(this.upstream).repositoriesForProject(pageRequest, projectId);
        log.debug("Retrieving page [start={}, limit={}] of upstream repositories for project with ID ({})", new Object[]{pageRequest.getStart(), pageRequest.getLimit(), projectId});
        Promise promise = this.newAuthenticatedJsonRequest(reposUrl).get().transform(this.toPageOfReposHandleNoProject(reposUrl));
        promise.done(page -> log.debug("Finished retrieving page [start={}, limit={}] of upstream repositories for project with ID ({})", new Object[]{pageRequest.getStart(), pageRequest.getLimit(), projectId}));
        promise.fail(error -> log.debug("Failed retrieving page [start={}, limit={}] of upstream repositories for project with ID ({})", new Object[]{pageRequest.getStart(), pageRequest.getLimit(), projectId, error}));
        return (Page)promise.claim();
    }

    private void notifyUpstream(String jsonEvent) {
        MirroringUrl url = this.mirroringNavBuilder.upstream(this.upstream).events(this.propertiesService.getServerId());
        ((Request.Builder)this.newAuthenticatedJsonRequest(url).setEntity(jsonEvent)).post().transform((ResponseTransformation)this.standardResponseBuilder(url).noContent(this.returnNull()).build()).claim();
    }

    private ApplicationUserWithPermissions parseAuthenticationResponse(Response response) {
        RestApplicationUserWithPermissions user;
        log.debug("The delegated authentication endpoint responded with status code {}", (Object)response.getStatusCode());
        if (response.isOk()) {
            user = this.parseEntity(response, RestApplicationUserWithPermissions.class).orElse(null);
            if (user == null) {
                log.warn("The delegated authentication endpoint gave an unrecognised response");
                throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.upstream", new Object[0]));
            }
        } else {
            RestErrors restErrors = this.parseEntity(response, RestErrors.class).orElse(null);
            if (log.isTraceEnabled() && restErrors != null) {
                this.traceErrorMessages(restErrors);
            }
            if (response.isUnauthorized()) {
                RestErrorMessage userCredentialsError = this.findUserCredentialsError(restErrors);
                if (userCredentialsError != null) {
                    log.debug("Delegated authentication failed because of invalid credentials: {}", (Object)userCredentialsError);
                    throw new DelegatedAuthenticationFailureException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failed", new Object[]{userCredentialsError.getMessage()}));
                }
                RestErrorMessage userCredentialsInsecureError = this.findUserCredentialsInsecureError(restErrors);
                if (userCredentialsInsecureError != null) {
                    log.debug("Delegated authentication failed because of insecure credentials: {}", (Object)userCredentialsInsecureError);
                    throw new SshAuthenticationInsecureKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.requirementsNotMet", new Object[0]));
                }
                RestErrorMessage userCredentialsExpiredError = this.findUserCredentialsExpiredError(restErrors);
                if (userCredentialsExpiredError != null) {
                    log.debug("Delegated authentication failed because of expired credentials: {}", (Object)userCredentialsExpiredError);
                    throw new SshAuthenticationExpiredKeyException(this.i18nService.createKeyedMessage("bitbucket.service.ssh.key.auth.sshkey.expired", new Object[0]));
                }
                RestErrorMessage userCaptchaError = this.findUserCaptchaError(restErrors);
                if (userCaptchaError != null) {
                    log.debug("Delegated authentication failed because the user is CAPTCHA'd upstream");
                    throw new CaptchaRequiredAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.captcha.required", new Object[]{Product.NAME}));
                }
                log.info("Delegated authentication failed because the upstream rejected our mirror credentials. Perhaps the mirror has been disabled on the upstream?");
                throw new UpstreamRequestUntrustedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.misconfiguration", new Object[0]));
            }
            log.warn("Delegated authentication failed because the upstream responded with an unexpected status code {}", (Object)response.getStatusCode());
            RestErrorMessage errorMessage = this.findFirstNonEmptyError(restErrors);
            if (errorMessage == null || StringUtils.isBlank((CharSequence)errorMessage.getMessage())) {
                throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.unexpected", new Object[0]));
            }
            throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.authentication.delegation.failure.unexpected.with.message", new Object[]{errorMessage.getMessage()}));
        }
        return user;
    }

    private <T> Optional<Page<T>> parseEntityPage(Response response, Class<? extends T> type) {
        String entity = response.getEntity();
        if (StringUtils.isBlank((CharSequence)entity)) {
            log.debug("The upstream server responded with code {} but the response entity was empty", (Object)response.getStatusCode());
            return Optional.empty();
        }
        if (log.isTraceEnabled()) {
            log.trace("The upstream server responded with code {} and entity: {}", (Object)response.getStatusCode(), (Object)entity);
        }
        try {
            JsonNode page = objectMapper.readTree(entity);
            if (page == null || page.isNull()) {
                log.info("The response from the upstream server is not a JSON object");
                return Optional.empty();
            }
            JsonNode valuesNode = page.get("values");
            if (valuesNode == null || valuesNode.isNull()) {
                log.info("The response from the upstream server doesn't appear to be a JSON page object");
                return Optional.empty();
            }
            ArrayList<Object> values = new ArrayList<Object>();
            for (JsonNode node : valuesNode) {
                values.add(ValidationUtils.validate((Validator)this.validator, (Object)objectMapper.treeToValue((TreeNode)node, type), (Class[])new Class[0]));
            }
            PageRequest pageRequest = PageUtils.newRequest((int)page.get("start").asInt(), (int)page.get("limit").asInt());
            return Optional.of(PageUtils.createPage(values, (boolean)page.get("isLastPage").asBoolean(), (PageRequest)pageRequest));
        }
        catch (IOException e) {
            log.warn("Failed to deserialize an instance of {} from the response", (Object)type.getName(), (Object)e);
            return Optional.empty();
        }
    }

    @MustBeClosed
    private InputStream openConnectionAndStream(MirroringUrl hashesUrl) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(hashesUrl.getAbsolute()).openConnection();
            connection.setRequestProperty("Accept", MediaType.JSON_UTF_8.toString());
            connection.setRequestProperty("Cache-Control", "no-store");
            this.mirrorJwtTokenHelper.generateToken(hashesUrl, "GET").ifPresent(token -> connection.setRequestProperty("Authorization", "JWT " + token));
            connection.setRequestProperty("Accept-Encoding", "gzip");
            connection.setRequestProperty("User-Agent", this.applicationName.get());
            connection.setRequestMethod("GET");
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                if ("gzip".equals(connection.getContentEncoding())) {
                    return new GZIPInputStream(connection.getInputStream());
                }
                return connection.getInputStream();
            }
            switch (responseCode) {
                case 401: {
                    throw new UpstreamRequestUntrustedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.untrusted.mirror", new Object[]{responseCode, connection.getResponseMessage()}));
                }
                case 429: {
                    throw new UpstreamRequestRateExceededException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.rate.exceeded", new Object[]{MirrorDescriptionUtils.describe(this.upstream), URI.create(hashesUrl.getAbsolute()).getPath()}));
                }
            }
            throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.response.unexpected", new Object[]{responseCode, connection.getResponseMessage()}));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ResponseTransformation<MirroringCapabilities> toCapabilities(MirroringUrl url) {
        return (ResponseTransformation)this.standardResponseBuilder(url).notFound(response -> DEFAULT_CAPABILITIES).ok(response -> this.parseEntity((Response)response, RestMirroringCapabilities.class).map(restCapabilities -> new MirroringCapabilities.Builder().features(restCapabilities.getFeatures()).roles(restCapabilities.getRoles()).repositoryListModes(restCapabilities.getRepositoryListModes()).build()).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
    }

    private ResponseTransformation<Page<RestServerExternalRepository>> toPageOfRepos(MirroringUrl url) {
        return (ResponseTransformation)this.repositoryEndpointResponseBuilder(url).notFound(this::throwRequestFailedUnexpectedResponse).ok(response -> this.parseEntityPage((Response)response, (Class)RestServerExternalRepository.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
    }

    private ResponseTransformation<Page<RestServerExternalRepository>> toPageOfReposHandleNoProject(MirroringUrl url) {
        return (ResponseTransformation)this.repositoryEndpointResponseBuilder(url).notFound(input -> {
            log.warn("Request to {} returned a 404 this most likely means a project was deleted on the upstream but not on the mirror. Returning an empty list of repositories", (Object)url.getAbsolute());
            return PageUtils.createEmptyPage((PageRequest)new PageRequestImpl(0, 0));
        }).ok(response -> this.parseEntityPage((Response)response, (Class)RestServerExternalRepository.class).orElseThrow(this.requestFailedUnexpectedResponseSupplier((Response)response))).build();
    }

    private void traceErrorMessages(RestErrors restErrors) {
        if (log.isTraceEnabled() && restErrors != null) {
            for (RestErrorMessage errorMessage : restErrors.getErrors()) {
                log.trace("Delegated authentication error: {}", (Object)errorMessage);
            }
        }
    }

    private AnalyticsSettings transformAnalyticsSettings(@Nonnull RestAnalyticsSettings analyticsSettings) {
        if (analyticsSettings.getSupportEntitlementNumber() == null) {
            throw new UpstreamRequestFailedException(this.i18nService.createKeyedMessage("bitbucket.mirroring.upstream.request.failed.response.unexpected", new Object[]{Response.Status.NOT_FOUND, ""}));
        }
        return new SimpleAnalyticsSettings(analyticsSettings.isCanCollectAnalytics(), analyticsSettings.getServerTime().orElse(-1L), analyticsSettings.getSupportEntitlementNumber());
    }

    private UpstreamSshSettings transformSshSettings(RestUpstreamSshSettings sshSettings) {
        return sshSettings == null ? null : new SimpleUpstreamSshSettings(sshSettings.isAccessKeysEnabled(), sshSettings.isEnabled(), sshSettings.getFingerprint(), sshSettings.getPort(), sshSettings.getBaseUrl());
    }

    private <T extends RuntimeException, R> Function<Throwable, R> wrapAsOrRethrowIfSame(Class<T> type, String messageKey, BiFunction<KeyedMessage, Throwable, T> ctor) {
        return e -> {
            if (type.isAssignableFrom(e.getClass())) {
                throw (RuntimeException)type.cast(e);
            }
            throw (RuntimeException)ctor.apply(this.i18nService.createKeyedMessage(messageKey, new Object[]{e}), (Throwable)e);
        };
    }

    @VisibleForTesting
    static final class DefaultApplicationNameSupplier
    implements Supplier<String> {
        private final ApplicationPropertiesService applicationProperties;

        DefaultApplicationNameSupplier(ApplicationPropertiesService applicationProperties) {
            this.applicationProperties = Objects.requireNonNull(applicationProperties);
        }

        @Override
        public String get() {
            return String.format("%s-%s (%s) / Mirror", this.applicationProperties.getDisplayName(), this.applicationProperties.getBuildVersion(), this.applicationProperties.getBuildNumber());
        }
    }

    private static class RestMinimalMirrorServer
    extends RestMapEntity {
        private RestMinimalMirrorServer() {
        }

        public String getId() {
            return this.getStringProperty("id");
        }
    }
}

