/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.mirroring.mirror.client;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mirroring.mirror.MirroringConfig;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.AuthRetryingUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.DefaultUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClient;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.InternalUpstreamClientFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.client.ThreadSleeper;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.JwtSignedRequestFactory;
import com.atlassian.bitbucket.internal.mirroring.mirror.jwt.MirrorJwtTokenHelper;
import com.atlassian.bitbucket.internal.mirroring.mirror.nav.MirroringNavBuilder;
import com.atlassian.bitbucket.internal.mirroring.ssh.encoding.PublicKeyEncodingHelper;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.mirroring.mirror.UpstreamServer;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.httpclient.api.HttpClient;
import jakarta.annotation.Nonnull;
import jakarta.validation.Validator;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultUpstreamClientFactory
implements InternalUpstreamClientFactory {
    private final MirroringConfig config;
    private final HttpClient httpClient;
    private final I18nService i18nService;
    private final JsonRenderer jsonRenderer;
    private final JwtSignedRequestFactory jwtSignedRequestFactory;
    private final MirrorJwtTokenHelper mirrorJwtTokenHelper;
    private final MirroringNavBuilder mirroringNavBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final PublicKeyEncodingHelper publicKeyHelper;
    private final Validator validator;

    @Autowired
    public DefaultUpstreamClientFactory(MirroringConfig config, HttpClient httpClient, I18nService i18nService, JsonRenderer jsonRenderer, JwtSignedRequestFactory jwtSignedRequestFactory, MirrorJwtTokenHelper mirrorJwtTokenHelper, MirroringNavBuilder mirroringNavBuilder, ApplicationPropertiesService propertiesService, PublicKeyEncodingHelper publicKeyHelper, Validator validator) {
        this.config = config;
        this.httpClient = httpClient;
        this.i18nService = i18nService;
        this.jsonRenderer = jsonRenderer;
        this.jwtSignedRequestFactory = jwtSignedRequestFactory;
        this.mirrorJwtTokenHelper = mirrorJwtTokenHelper;
        this.mirroringNavBuilder = mirroringNavBuilder;
        this.propertiesService = propertiesService;
        this.publicKeyHelper = publicKeyHelper;
        this.validator = validator;
    }

    @Override
    @Nonnull
    public InternalUpstreamClient create(@Nonnull UpstreamServer upstream) {
        Objects.requireNonNull(upstream, "upstream");
        return new AuthRetryingUpstreamClient(new DefaultUpstreamClient(this.config, this.httpClient, this.i18nService, this.jsonRenderer, this.mirroringNavBuilder, this.mirrorJwtTokenHelper, this.publicKeyHelper, this.propertiesService, this.jwtSignedRequestFactory, upstream, this.validator), new ThreadSleeper());
    }
}

